/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.dynamicbuffer;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.preprocessor.GlslPreprocessor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.ext.ShaderInstanceExtension;
import foundry.veil.impl.ThreadTaskScheduler;
import foundry.veil.impl.client.render.shader.SimpleShaderProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import net.minecraft.FileUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.apache.commons.io.IOUtils;

public class VanillaShaderCompiler {
    private static final Set<String> LAST_FRAME_SHADERS = ConcurrentHashMap.newKeySet();
    private ThreadTaskScheduler scheduler;

    private void compileShader(ShaderInstance shader) {
        ShaderInstanceExtension extension = (ShaderInstanceExtension)shader;
        Collection<ResourceLocation> shaderSources = extension.veil$getShaderSources();
        VertexFormat vertexFormat = shader.getVertexFormat();
        final ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
        SimpleShaderProcessor.setup((ResourceProvider)resourceManager);
        for (final ResourceLocation path : shaderSources) {
            try {
                BufferedReader reader = resourceManager.openAsReader(path);
                try {
                    String source = IOUtils.toString((Reader)reader);
                    GlslPreprocessor preprocessor = new GlslPreprocessor(this){
                        private final Set<String> importedPaths = Sets.newHashSet();

                        public String applyImport(boolean useFullPath, String directory) {
                            directory = FileUtil.normalizeResourcePath((String)((useFullPath ? path.getPath() : "shaders/include/") + directory));
                            if (!this.importedPaths.add(directory)) {
                                return null;
                            }
                            ResourceLocation resourcelocation = ResourceLocation.parse((String)directory);
                            try {
                                String s2;
                                try (BufferedReader reader = resourceManager.openAsReader(resourcelocation);){
                                    s2 = IOUtils.toString((Reader)reader);
                                }
                                return s2;
                            }
                            catch (IOException e) {
                                Veil.LOGGER.error("Could not open GLSL import {}: {}", (Object)directory, (Object)e.getMessage());
                                return "#error " + e.getMessage();
                            }
                        }
                    };
                    source = String.join((CharSequence)"", preprocessor.process(source));
                    boolean vertex = path.getPath().endsWith(".vsh");
                    String processed = SimpleShaderProcessor.modify(shader.getName(), path, vertexFormat, vertex ? 35633 : 35632, source);
                    RenderSystem.recordRenderCall(() -> extension.veil$recompile(vertex, processed));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Throwable t) {
                Veil.LOGGER.error("Couldn't load vanilla shader from {}", (Object)path, (Object)t);
            }
        }
        SimpleShaderProcessor.free();
    }

    public CompletableFuture<?> reload(Collection<ShaderInstance> shaders) {
        ThreadTaskScheduler scheduler;
        if (this.scheduler != null) {
            this.scheduler.cancel();
        }
        ConcurrentHashMap<String, ShaderInstance> shaderMap = new ConcurrentHashMap<String, ShaderInstance>(shaders.size());
        for (ShaderInstance shader : shaders) {
            shaderMap.put(shader.getName(), shader);
        }
        this.scheduler = scheduler = new ThreadTaskScheduler("VeilShaderCompile", Math.max(1, Runtime.getRuntime().availableProcessors() / 4), () -> {
            for (String lastFrameShader : LAST_FRAME_SHADERS) {
                ShaderInstance shader = (ShaderInstance)shaderMap.remove(lastFrameShader);
                if (shader == null) continue;
                return () -> this.compileShader(shader);
            }
            Iterator iterator = shaderMap.values().iterator();
            if (iterator.hasNext()) {
                ShaderInstance shader = (ShaderInstance)iterator.next();
                iterator.remove();
                return () -> this.compileShader(shader);
            }
            return null;
        });
        CompletableFuture<?> future = scheduler.getCompletedFuture();
        future.thenRunAsync(() -> {
            if (!scheduler.isCancelled()) {
                Veil.LOGGER.info("Compiled {} vanilla shaders", (Object)shaders.size());
            }
        }, (Executor)Minecraft.getInstance());
        return future;
    }

    public boolean isCompilingShaders() {
        return this.scheduler != null && !this.scheduler.getCompletedFuture().isDone();
    }

    public static void markRendered(String shaderInstace) {
        if (VeilRenderSystem.renderer().getVanillaShaderCompiler().isCompilingShaders()) {
            LAST_FRAME_SHADERS.add(shaderInstace);
        }
    }

    public static void clear() {
        LAST_FRAME_SHADERS.clear();
    }
}

