/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.glsl.node;

import foundry.veil.impl.glsl.grammar.GlslSpecifiedType;
import foundry.veil.impl.glsl.node.GlslCompoundNode;
import foundry.veil.impl.glsl.node.GlslEmptyNode;
import foundry.veil.impl.glsl.node.primary.GlslBoolConstantNode;
import foundry.veil.impl.glsl.node.primary.GlslFloatConstantNode;
import foundry.veil.impl.glsl.node.primary.GlslIntConstantNode;
import foundry.veil.impl.glsl.node.primary.GlslIntFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public interface GlslNode {
    public String getSourceString();

    @Nullable
    default public GlslSpecifiedType getType() {
        return null;
    }

    default public List<GlslNode> toList() {
        return new ArrayList<GlslNode>(Collections.singleton(this));
    }

    public Stream<GlslNode> stream();

    public static GlslIntConstantNode intConstant(int value) {
        return new GlslIntConstantNode(GlslIntFormat.DECIMAL, true, value);
    }

    public static GlslIntConstantNode unsignedIntConstant(int value) {
        return new GlslIntConstantNode(GlslIntFormat.DECIMAL, false, value);
    }

    public static GlslFloatConstantNode floatConstant(float value) {
        return new GlslFloatConstantNode(value);
    }

    public static GlslBoolConstantNode booleanConstant(boolean value) {
        return new GlslBoolConstantNode(value);
    }

    public static GlslNode compound(Collection<GlslNode> nodes) {
        if (nodes.isEmpty()) {
            return GlslEmptyNode.INSTANCE;
        }
        if (nodes.size() == 1) {
            return nodes.iterator().next();
        }
        ArrayList<GlslNode> list = new ArrayList<GlslNode>();
        for (GlslNode node : nodes) {
            if (!(node instanceof GlslCompoundNode)) {
                list.clear();
                list.addAll(nodes);
                break;
            }
            GlslCompoundNode compoundNode = (GlslCompoundNode)node;
            list.addAll(compoundNode.getChildren());
        }
        return new GlslCompoundNode(list);
    }

    public static GlslNode compound(GlslNode ... nodes) {
        if (nodes.length == 0) {
            return GlslEmptyNode.INSTANCE;
        }
        if (nodes.length == 1) {
            return nodes[0];
        }
        return new GlslCompoundNode(new ArrayList<GlslNode>(Arrays.asList(nodes)));
    }
}

