/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.necromancer.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import foundry.veil.api.client.necromancer.Skeleton;
import foundry.veil.api.client.necromancer.SkeletonParent;
import foundry.veil.api.client.necromancer.animation.Animator;
import foundry.veil.api.client.necromancer.render.NecromancerEntityRenderLayer;
import foundry.veil.api.client.necromancer.render.Skin;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public abstract class NecromancerEntityRenderer<T extends Entity, M extends Skeleton<T>>
extends EntityRenderer<T> {
    final Function<T, M> skeletonFactory;
    final BiFunction<T, M, Animator<T, M>> animatorFactory;
    final List<NecromancerEntityRenderLayer<T, M>> layers;

    protected NecromancerEntityRenderer(EntityRendererProvider.Context pContext, Function<T, M> skeletonFactory, BiFunction<T, M, Animator<T, M>> animatorFactory, float shadowRadius) {
        super(pContext);
        this.skeletonFactory = skeletonFactory;
        this.animatorFactory = animatorFactory;
        this.shadowRadius = shadowRadius;
        this.layers = new ArrayList<NecromancerEntityRenderLayer<T, M>>();
    }

    public void addLayer(NecromancerEntityRenderLayer<T, M> layer) {
        this.layers.add(layer);
    }

    public void setupEntity(T entity) {
        Skeleton skeleton = (Skeleton)this.skeletonFactory.apply(entity);
        ((SkeletonParent)entity).setSkeleton(skeleton);
        ((SkeletonParent)entity).setAnimator(this.animatorFactory.apply(entity, skeleton));
    }

    public abstract Skin<M> getSkin(T var1);

    public void render(T pEntity, float pEntityYaw, float pPartialTicks, PoseStack poseStack, MultiBufferSource pBuffer, int pPackedLight) {
        poseStack.pushPose();
        float scale = 0.0625f;
        poseStack.scale(scale, scale, scale);
        Minecraft minecraft = Minecraft.getInstance();
        boolean invisible = pEntity.isInvisibleTo((Player)minecraft.player);
        boolean glowing = minecraft.shouldEntityAppearGlowing(pEntity);
        boolean shouldRender = !invisible;
        RenderType rendertype = this.getRenderType(pEntity, this.getTextureLocation((Entity)pEntity));
        Object skeleton = ((SkeletonParent)pEntity).getSkeleton();
        Skin<M> skin = this.getSkin(pEntity);
        if (shouldRender && skeleton != null && skin != null) {
            this.renderSkin(pEntity, skeleton, skin, ((Entity)pEntity).tickCount, pPartialTicks, poseStack, pBuffer.getBuffer(rendertype), pPackedLight, this.getOverlayCoords(pEntity), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (!pEntity.isSpectator() && rendertype != null && skeleton != null) {
            for (NecromancerEntityRenderLayer necromancerEntityRenderLayer : this.layers) {
                necromancerEntityRenderLayer.render(poseStack, pBuffer, pPackedLight, pEntity, skeleton, pPartialTicks);
            }
        }
        poseStack.popPose();
        super.render(pEntity, pEntityYaw, pPartialTicks, poseStack, pBuffer, pPackedLight);
    }

    public int getOverlayCoords(T pEntity) {
        int n;
        if (pEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)pEntity;
            n = LivingEntityRenderer.getOverlayCoords((LivingEntity)living, (float)0.0f);
        } else {
            n = OverlayTexture.NO_OVERLAY;
        }
        return n;
    }

    public void renderSkin(T entity, M skeleton, Skin<M> skin, int ticksExisted, float partialTicks, PoseStack poseStack, VertexConsumer consumer, int packedLight, int packedOverlay, float r, float g, float b, float a) {
        skin.render(skeleton, ticksExisted, partialTicks, poseStack, consumer, packedLight, packedOverlay, r, g, b, a);
    }

    public abstract RenderType getRenderType(T var1, ResourceLocation var2);

    protected RenderType getRenderType(T pLivingEntity, boolean visible, boolean spectator, boolean glowing) {
        ResourceLocation texture = this.getTextureLocation((Entity)pLivingEntity);
        if (!visible) {
            return null;
        }
        return this.getRenderType(pLivingEntity, texture);
    }
}

