/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader;

import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.api.client.render.shader.definition.ShaderPreDefinitions;
import foundry.veil.api.client.render.shader.processor.ShaderCustomProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderModifyProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderPreProcessor;
import foundry.veil.api.client.render.shader.program.ProgramDefinition;
import foundry.veil.impl.client.render.dynamicbuffer.DynamicBufferProcessor;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class SimpleShaderProcessor {
    private static final ThreadLocal<ShaderPreProcessor> PROCESSOR = new ThreadLocal();
    private static final Set<String> LAST_FRAME_SHADERS = new HashSet<String>();

    public static void setup(ResourceProvider resourceProvider) {
        int activeBuffers = VeilRenderSystem.renderer().getDynamicBufferManger().getActiveBuffers();
        PROCESSOR.set(ShaderPreProcessor.allOf(new ShaderModifyProcessor(), new ShaderCustomProcessor(resourceProvider), new DynamicBufferProcessor(DynamicBufferType.decode(activeBuffers))));
    }

    public static void free() {
        PROCESSOR.remove();
    }

    public static String modify(@Nullable String shaderInstance, @Nullable ResourceLocation name, @Nullable VertexFormat vertexFormat, int type, String source) throws IOException {
        ShaderPreProcessor processor = PROCESSOR.get();
        if (processor == null) {
            throw new NullPointerException("Processor not initialized");
        }
        return processor.modify(new Context(shaderInstance, name, type, vertexFormat), source);
    }

    public static void markRendered(String shaderInstace) {
        if (VeilRenderSystem.renderer().getDynamicBufferManger().isCompilingShaders()) {
            LAST_FRAME_SHADERS.add(shaderInstace);
        }
    }

    public static void clear() {
        LAST_FRAME_SHADERS.clear();
    }

    public static Set<String> getLastFrameShaders() {
        return LAST_FRAME_SHADERS;
    }

    private record Context(String shaderInstance, ResourceLocation name, int type, VertexFormat vertexFormat) implements ShaderPreProcessor.Context
    {
        @Override
        public String modify(@Nullable ResourceLocation name, String source) throws IOException {
            return PROCESSOR.get().modify(new Context(this.shaderInstance, name, this.type, this.vertexFormat), source);
        }

        @Override
        public void addUniformBinding(String name, int binding) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addDefinitionDependency(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addInclude(ResourceLocation name) {
        }

        @Override
        public Set<ResourceLocation> includes() {
            return Collections.emptySet();
        }

        @Override
        public boolean isSourceFile() {
            return true;
        }

        @Override
        @Nullable
        public ProgramDefinition definition() {
            return null;
        }

        @Override
        @Nullable
        public ShaderPreDefinitions preDefinitions() {
            return null;
        }
    }
}

