/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.dynamicbuffer;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.preprocessor.GlslPreprocessor;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.ext.ShaderInstanceExtension;
import foundry.veil.impl.client.render.shader.SimpleShaderProcessor;
import foundry.veil.mixin.accessor.GameRendererAccessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.FileUtil;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.NativeResource;

public class DynamicBufferManger
implements NativeResource {
    private static final int[] GL_MAPPING = new int[]{35633, 36488, 36487, 36313, 35632, 37305};
    public static final ResourceLocation MAIN_WRAPPER = Veil.veilPath("dynamic_main");
    private int activeBuffers = 0;
    private boolean enabled = false;
    private final int[] clearBuffers = Arrays.stream(DynamicBufferType.values()).mapToInt(type -> 36065 + type.ordinal()).toArray();
    private final Map<ResourceLocation, AdvancedFbo> framebuffers = new HashMap<ResourceLocation, AdvancedFbo>();
    private final EnumMap<DynamicBufferType, DynamicBuffer> dynamicBuffers = new EnumMap(DynamicBufferType.class);
    private final AtomicBoolean vanillaCancelled;
    private CompletableFuture<?> vanillaLoadFuture;

    public DynamicBufferManger(int width, int height) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer textures = stack.mallocInt(DynamicBufferType.values().length);
            GL20C.glGenTextures((IntBuffer)textures);
            for (DynamicBufferType value : DynamicBufferType.values()) {
                DynamicBuffer buffer = new DynamicBuffer(value, textures.get(value.ordinal()));
                buffer.init(width, height);
                this.dynamicBuffers.put(value, buffer);
            }
        }
        this.vanillaCancelled = new AtomicBoolean(false);
        this.vanillaLoadFuture = CompletableFuture.completedFuture(null);
    }

    private void deleteFramebuffers() {
        for (Map.Entry<ResourceLocation, AdvancedFbo> entry : this.framebuffers.entrySet()) {
            entry.getValue().free();
            VeilRenderSystem.renderer().getFramebufferManager().removeFramebuffer(entry.getKey());
        }
        this.framebuffers.clear();
    }

    public CompletableFuture<?> reloadVanillaShaders(Collection<ShaderInstance> shaders) {
        this.vanillaCancelled.set(true);
        this.vanillaLoadFuture = CompletableFuture.runAsync(() -> {
            this.vanillaCancelled.set(false);
            ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
            Veil.LOGGER.info("Compiling {} vanilla shaders", (Object)shaders.size());
            SimpleShaderProcessor.setup((ResourceProvider)resourceManager);
            HashMap<String, ShaderInstance> shaderMap = new HashMap<String, ShaderInstance>(shaders.size());
            for (ShaderInstance shader : shaders) {
                shaderMap.put(shader.getName(), shader);
            }
            block1: while (!shaderMap.isEmpty()) {
                if (this.vanillaCancelled.get()) {
                    return;
                }
                Set<String> lastFrameShaders = SimpleShaderProcessor.getLastFrameShaders();
                boolean compiled = false;
                for (String lastFrameShader : lastFrameShaders) {
                    ShaderInstance shader = (ShaderInstance)shaderMap.remove(lastFrameShader);
                    if (shader == null || !shader.getName().startsWith("rendertype_")) continue;
                    this.compileShader((ResourceProvider)resourceManager, shader);
                    compiled = true;
                    break;
                }
                if (compiled) continue;
                Iterator iterator = shaderMap.values().iterator();
                while (iterator.hasNext()) {
                    ShaderInstance shader = (ShaderInstance)iterator.next();
                    iterator.remove();
                    if (!shader.getName().startsWith("rendertype_")) continue;
                    this.compileShader((ResourceProvider)resourceManager, shader);
                    continue block1;
                }
            }
            SimpleShaderProcessor.free();
            if (!this.vanillaCancelled.get()) {
                Veil.LOGGER.info("Compiled {} vanilla shaders", (Object)shaders.size());
            }
        }, Util.backgroundExecutor());
        return this.vanillaLoadFuture;
    }

    private void compileShader(final ResourceProvider resourceProvider, ShaderInstance shader) {
        ShaderInstanceExtension extension = (ShaderInstanceExtension)shader;
        Collection<ResourceLocation> shaderSources = extension.veil$getShaderSources();
        VertexFormat vertexFormat = shader.getVertexFormat();
        for (final ResourceLocation path : shaderSources) {
            try {
                BufferedReader reader = resourceProvider.openAsReader(path);
                try {
                    String source = IOUtils.toString((Reader)reader);
                    GlslPreprocessor preprocessor = new GlslPreprocessor(this){
                        private final Set<String> importedPaths = Sets.newHashSet();

                        public String applyImport(boolean useFullPath, String directory) {
                            directory = FileUtil.normalizeResourcePath((String)((useFullPath ? path.getPath() : "shaders/include/") + directory));
                            if (!this.importedPaths.add(directory)) {
                                return null;
                            }
                            ResourceLocation resourcelocation = ResourceLocation.parse((String)directory);
                            try {
                                String s2;
                                try (BufferedReader reader = resourceProvider.openAsReader(resourcelocation);){
                                    s2 = IOUtils.toString((Reader)reader);
                                }
                                return s2;
                            }
                            catch (IOException e) {
                                Veil.LOGGER.error("Could not open GLSL import {}: {}", (Object)directory, (Object)e.getMessage());
                                return "#error " + e.getMessage();
                            }
                        }
                    };
                    source = String.join((CharSequence)"", preprocessor.process(source));
                    boolean vertex = path.getPath().endsWith(".vsh");
                    String processed = SimpleShaderProcessor.modify(shader.getName(), path, vertexFormat, vertex ? 35633 : 35632, source);
                    RenderSystem.recordRenderCall(() -> extension.veil$recompile(vertex, processed));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Throwable t) {
                Veil.LOGGER.error("Couldn't load vanilla shader from {}", (Object)path, (Object)t);
            }
        }
    }

    public boolean isCompilingShaders() {
        return !this.vanillaLoadFuture.isDone();
    }

    public int getActiveBuffers() {
        return this.activeBuffers;
    }

    public int getBufferTexture(DynamicBufferType type) {
        return this.dynamicBuffers.get((Object)((Object)type)).textureId;
    }

    public boolean setActiveBuffers(int activeBuffers) {
        if (this.activeBuffers == activeBuffers) {
            return false;
        }
        this.activeBuffers = activeBuffers;
        this.reloadVanillaShaders(((GameRendererAccessor)Minecraft.getInstance().gameRenderer).getShaders().values());
        this.deleteFramebuffers();
        try {
            VeilRenderSystem.renderer().getShaderManager().setActiveBuffers(activeBuffers);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    @ApiStatus.Internal
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void free() {
        this.deleteFramebuffers();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer textures = stack.mallocInt(DynamicBufferType.values().length);
            for (DynamicBufferType value : DynamicBufferType.values()) {
                textures.put(value.ordinal(), this.dynamicBuffers.get((Object)((Object)value)).textureId);
            }
            GL20C.glDeleteTextures((IntBuffer)textures);
        }
        this.dynamicBuffers.clear();
    }

    @ApiStatus.Internal
    public void setupRenderState(ResourceLocation name, @Nullable RenderTarget renderTarget) {
        if (this.activeBuffers == 0 || !this.enabled) {
            return;
        }
        if (renderTarget == null) {
            VeilRenderSystem.renderer().getFramebufferManager().removeFramebuffer(name);
            AdvancedFbo fbo = this.framebuffers.remove(name);
            if (fbo != null) {
                fbo.free();
            }
            return;
        }
        AdvancedFbo fbo = this.framebuffers.get(name);
        if (fbo == null) {
            AdvancedFbo.Builder builder = AdvancedFbo.withSize(renderTarget.width, renderTarget.height);
            builder.addColorTextureWrapper(renderTarget.getColorTextureId());
            for (Map.Entry<DynamicBufferType, DynamicBuffer> entry : this.dynamicBuffers.entrySet()) {
                DynamicBufferType type = entry.getKey();
                if ((this.activeBuffers & type.getMask()) == 0) continue;
                builder.setName(type.getSourceName()).addColorTextureWrapper(entry.getValue().textureId);
            }
            builder.setDepthTextureWrapper(renderTarget.getDepthTextureId());
            fbo = builder.build(true);
            this.framebuffers.put(name, fbo);
        }
        VeilRenderSystem.renderer().getFramebufferManager().setFramebuffer(name, fbo);
        fbo.bind(true);
    }

    @ApiStatus.Internal
    public void clearRenderState() {
        if (this.activeBuffers == 0 || !this.enabled) {
            return;
        }
        this.setupRenderState(MAIN_WRAPPER, Minecraft.getInstance().getMainRenderTarget());
    }

    @ApiStatus.Internal
    public void clear() {
        for (AdvancedFbo framebuffer : this.framebuffers.values()) {
            framebuffer.bind(false);
            GL20C.glDrawBuffers((int[])this.clearBuffers);
            GlStateManager._clear((int)16384, (boolean)Minecraft.ON_OSX);
            GL20C.glDrawBuffers((int[])framebuffer.getDrawBuffers());
        }
    }

    @ApiStatus.Internal
    public void resizeFramebuffers(int width, int height) {
        this.deleteFramebuffers();
        for (DynamicBuffer buffer : this.dynamicBuffers.values()) {
            buffer.resize(width, height);
        }
    }

    public static int getShaderIndex(int glType, int activeBuffers) {
        for (int i = 0; i < GL_MAPPING.length; ++i) {
            if (GL_MAPPING[i] != glType) continue;
            return i | activeBuffers << 4;
        }
        throw new IllegalArgumentException("Invalid GL Shader Type: 0x" + Integer.toHexString(glType).toUpperCase(Locale.ROOT));
    }

    private record DynamicBuffer(DynamicBufferType type, int textureId) {
        public void init(int width, int height) {
            GlStateManager._bindTexture((int)this.textureId);
            GlStateManager._texParameter((int)3553, (int)10241, (int)9728);
            GlStateManager._texParameter((int)3553, (int)10240, (int)9728);
            GlStateManager._texParameter((int)3553, (int)33085, (int)0);
            GlStateManager._texParameter((int)3553, (int)33082, (int)0);
            GlStateManager._texParameter((int)3553, (int)33083, (int)0);
            GlStateManager._texParameter((int)3553, (int)34049, (float)0.0f);
            GlStateManager._texParameter((int)3553, (int)10242, (int)33071);
            GlStateManager._texParameter((int)3553, (int)10243, (int)33071);
            GlStateManager._texImage2D((int)3553, (int)0, (int)this.type.getInternalFormat(), (int)width, (int)height, (int)0, (int)this.type.getTexelFormat(), (int)5125, null);
        }

        public void resize(int width, int height) {
            GlStateManager._bindTexture((int)this.textureId);
            GlStateManager._texImage2D((int)3553, (int)0, (int)this.type.getInternalFormat(), (int)width, (int)height, (int)0, (int)this.type.getTexelFormat(), (int)5125, null);
        }
    }
}

