/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.framebuffer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.FramebufferAttachmentDefinition;
import foundry.veil.api.molang.MolangExpressionCodec;
import foundry.veil.api.molang.VeilMolang;
import gg.moonflower.molangcompiler.api.MolangEnvironment;
import gg.moonflower.molangcompiler.api.MolangExpression;
import gg.moonflower.molangcompiler.api.MolangRuntime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

public record FramebufferDefinition(MolangExpression width, MolangExpression height, FramebufferAttachmentDefinition[] colorBuffers, @Nullable FramebufferAttachmentDefinition depthBuffer, boolean autoClear) {
    public static final MolangExpression DEFAULT_WIDTH;
    public static final MolangExpression DEFAULT_HEIGHT;
    private static final Codec<Optional<FramebufferAttachmentDefinition>> DEPTH_CODEC;
    private static final Codec<FramebufferDefinition> FULL_CODEC;
    private static final Codec<FramebufferDefinition> COMPACT_CODEC;
    public static final Codec<FramebufferDefinition> CODEC;

    public FramebufferDefinition(MolangExpression width, MolangExpression height, FramebufferAttachmentDefinition[] colorBuffers, @Nullable FramebufferAttachmentDefinition depthBuffer, boolean autoClear) {
        if (colorBuffers.length < 1) {
            throw new IllegalArgumentException("At least 1 color buffer must be defined");
        }
    }

    private static DataResult<List<FramebufferAttachmentDefinition>> colorSizeCheck(List<FramebufferAttachmentDefinition> definitions) {
        if (definitions.isEmpty()) {
            return DataResult.error(() -> "There must be at least 1 color buffer");
        }
        return DataResult.success(definitions);
    }

    public AdvancedFbo.Builder createBuilder(int screenWidth, int screenHeight) {
        MolangRuntime runtime = (MolangRuntime)MolangRuntime.runtime().setQuery("screen_width", (float)screenWidth).setQuery("screen_height", (float)screenHeight).create();
        return this.createBuilder((MolangEnvironment)runtime);
    }

    public AdvancedFbo.Builder createBuilder(MolangEnvironment environment) {
        int width = (int)environment.safeResolve(this.width);
        int height = (int)environment.safeResolve(this.height);
        Validate.inclusiveBetween((long)1L, (long)VeilRenderSystem.maxFramebufferWidth(), (long)width, (String)("width must be between 1 and " + VeilRenderSystem.maxFramebufferWidth()));
        Validate.inclusiveBetween((long)1L, (long)VeilRenderSystem.maxFramebufferHeight(), (long)height, (String)("height must be between 1 and " + VeilRenderSystem.maxFramebufferHeight()));
        AdvancedFbo.Builder builder = AdvancedFbo.withSize(width, height);
        for (FramebufferAttachmentDefinition definition : this.colorBuffers) {
            if (definition.type() == FramebufferAttachmentDefinition.Type.RENDER_BUFFER) {
                builder.setSamples(definition.levels()).addColorRenderBuffer();
                continue;
            }
            builder.setMipmaps(definition.levels()).setLinear(definition.linear()).setName(definition.name()).setFormat(definition.format()).addColorTextureBuffer(definition.dataType().getId());
        }
        if (this.depthBuffer != null) {
            if (this.depthBuffer.type() == FramebufferAttachmentDefinition.Type.RENDER_BUFFER) {
                builder.setSamples(this.depthBuffer.levels()).setDepthRenderBuffer();
            } else {
                builder.setMipmaps(this.depthBuffer.levels()).setLinear(this.depthBuffer.linear()).setName(this.depthBuffer.name()).setFormat(this.depthBuffer.format()).setDepthTextureBuffer(this.depthBuffer.dataType().getId());
            }
        }
        return builder;
    }

    static {
        try {
            DEFAULT_WIDTH = VeilMolang.get().compile("q.screen_width");
            DEFAULT_HEIGHT = VeilMolang.get().compile("q.screen_height");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        DEPTH_CODEC = Codec.either(FramebufferAttachmentDefinition.DEPTH_CODEC, (Codec)Codec.BOOL).xmap(either -> (Optional)either.map(Optional::of, compact -> compact != false ? Optional.of(new FramebufferAttachmentDefinition(FramebufferAttachmentDefinition.Type.TEXTURE, FramebufferAttachmentDefinition.Format.DEPTH_COMPONENT, FramebufferAttachmentDefinition.DataType.FLOAT, true, false, 0, null)) : Optional.empty()), optional -> {
            if (optional.isEmpty()) {
                return Either.right((Object)false);
            }
            FramebufferAttachmentDefinition definition = (FramebufferAttachmentDefinition)optional.get();
            if (definition.isCompactDepthAttachment()) {
                return Either.right((Object)true);
            }
            return Either.left((Object)definition);
        });
        FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MolangExpressionCodec.CODEC.optionalFieldOf("width", (Object)DEFAULT_WIDTH).forGetter(FramebufferDefinition::width), (App)MolangExpressionCodec.CODEC.optionalFieldOf("height", (Object)DEFAULT_HEIGHT).forGetter(FramebufferDefinition::height), (App)FramebufferAttachmentDefinition.COLOR_CODEC.listOf().fieldOf("color_buffers").flatXmap(FramebufferDefinition::colorSizeCheck, FramebufferDefinition::colorSizeCheck).forGetter(definition -> Arrays.asList(definition.colorBuffers)), (App)DEPTH_CODEC.fieldOf("depth").forGetter(definition -> Optional.ofNullable(definition.depthBuffer)), (App)Codec.BOOL.optionalFieldOf("autoClear", (Object)true).forGetter(FramebufferDefinition::autoClear)).apply((Applicative)instance, (width, height, colorBuffers, depthBuffer, autoClear) -> new FramebufferDefinition((MolangExpression)width, (MolangExpression)height, (FramebufferAttachmentDefinition[])colorBuffers.toArray(FramebufferAttachmentDefinition[]::new), depthBuffer.orElse(null), (boolean)autoClear)));
        COMPACT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MolangExpressionCodec.CODEC.optionalFieldOf("width", (Object)DEFAULT_WIDTH).forGetter(FramebufferDefinition::width), (App)MolangExpressionCodec.CODEC.optionalFieldOf("height", (Object)DEFAULT_HEIGHT).forGetter(FramebufferDefinition::height), (App)FramebufferAttachmentDefinition.Type.CODEC.optionalFieldOf("type", (Object)FramebufferAttachmentDefinition.Type.TEXTURE).forGetter(definition -> definition.colorBuffers[0].type()), (App)FramebufferAttachmentDefinition.Format.CODEC.optionalFieldOf("format", (Object)FramebufferAttachmentDefinition.Format.RGBA8).forGetter(definition -> definition.colorBuffers[0].format()), (App)FramebufferAttachmentDefinition.DataType.CODEC.optionalFieldOf("dataType", (Object)FramebufferAttachmentDefinition.DataType.UNSIGNED_BYTE).forGetter(definition -> definition.colorBuffers[0].dataType()), (App)Codec.BOOL.optionalFieldOf("linear", (Object)false).forGetter(definition -> definition.colorBuffers[0].linear()), (App)Codec.INT.optionalFieldOf("levels", (Object)0).forGetter(definition -> definition.colorBuffers[0].levels()), (App)Codec.STRING.optionalFieldOf("name").forGetter(definition -> Optional.ofNullable(definition.colorBuffers[0].name())), (App)DEPTH_CODEC.fieldOf("depth").forGetter(definition -> Optional.ofNullable(definition.depthBuffer)), (App)Codec.BOOL.optionalFieldOf("autoClear", (Object)true).forGetter(FramebufferDefinition::autoClear)).apply((Applicative)instance, (width, height, type, format, dataType, linear, levels, name, depth, autoClear) -> new FramebufferDefinition((MolangExpression)width, (MolangExpression)height, new FramebufferAttachmentDefinition[]{new FramebufferAttachmentDefinition((FramebufferAttachmentDefinition.Type)((Object)((Object)type)), (FramebufferAttachmentDefinition.Format)((Object)((Object)format)), (FramebufferAttachmentDefinition.DataType)((Object)((Object)dataType)), false, (boolean)linear, (int)levels, name.orElse(null))}, depth.orElse(null), (boolean)autoClear)));
        CODEC = Codec.either(FULL_CODEC, COMPACT_CODEC).xmap(either -> (FramebufferDefinition)either.map(left -> left, right -> right), definition -> definition.colorBuffers.length == 1 ? Either.right((Object)definition) : Either.left((Object)definition));
    }
}

