/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.definition;

import foundry.veil.api.client.render.shader.definition.DynamicShaderBlock;
import foundry.veil.impl.client.render.shader.definition.DynamicShaderBlockImpl;
import foundry.veil.impl.client.render.shader.definition.SizedShaderBlockImpl;
import foundry.veil.impl.client.render.shader.definition.WrapperShaderBlockImpl;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NativeResource;

public interface ShaderBlock<T>
extends NativeResource {
    public static <T> ShaderBlock<T> withSize(int binding, int size, BiConsumer<T, ByteBuffer> serializer) {
        return new SizedShaderBlockImpl<T>(binding, size, serializer);
    }

    public static <T> DynamicShaderBlock<T> dynamic(int binding, BiConsumer<T, ByteBuffer> serializer) {
        return ShaderBlock.dynamic(binding, 256, serializer);
    }

    public static <T> DynamicShaderBlock<T> dynamic(int binding, int initialSize, BiConsumer<T, ByteBuffer> serializer) {
        return new DynamicShaderBlockImpl<T>(binding, initialSize, serializer);
    }

    public static DynamicShaderBlock<?> wrapper(int binding, int buffer) {
        return new WrapperShaderBlockImpl(binding, buffer);
    }

    default public void update(@Nullable T value) {
        if (!Objects.equals(this.getValue(), value)) {
            this.set(value);
        }
    }

    public void set(@Nullable T var1);

    @Nullable
    public T getValue();
}

