/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.resource;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.resource.VeilResource;
import foundry.veil.api.resource.VeilResourceInfo;
import foundry.veil.api.resource.VeilResourceLoader;
import foundry.veil.api.resource.VeilResourceManager;
import foundry.veil.api.resource.type.UnknownResource;
import foundry.veil.api.util.CompositeReloadListener;
import foundry.veil.ext.PackResourcesExtension;
import foundry.veil.impl.resource.VeilPackResources;
import foundry.veil.impl.resource.loader.FramebufferResourceLoader;
import foundry.veil.impl.resource.loader.McMetaResourceLoader;
import foundry.veil.impl.resource.loader.PostPipelineResourceLoader;
import foundry.veil.impl.resource.loader.RenderTypeResourceLoader;
import foundry.veil.impl.resource.loader.ShaderIncludeLoader;
import foundry.veil.impl.resource.loader.ShaderResourceLoader;
import foundry.veil.impl.resource.loader.TextResourceLoader;
import foundry.veil.impl.resource.loader.TextureResourceLoader;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NativeResource;

public class VeilResourceManagerImpl
implements VeilResourceManager,
NativeResource {
    private static final AtomicInteger WATCHER_ID = new AtomicInteger(1);
    private final ObjectList<VeilResourceLoader> loaders;
    private final List<VeilPackResources> packResources;
    private final Object2ObjectMap<Path, PackResourceListener> watchers;
    private ResourceManager serverResourceManager = ResourceManager.Empty.INSTANCE;

    public VeilResourceManagerImpl() {
        this.loaders = new ObjectArrayList(8);
        this.packResources = new LinkedList<VeilPackResources>();
        this.watchers = new Object2ObjectArrayMap();
    }

    public void addVeilLoaders(VeilRenderer renderer) {
        this.addLoader(new ShaderResourceLoader(renderer.getShaderManager()));
        this.addLoader(new ShaderResourceLoader(renderer.getDeferredRenderer().getDeferredShaderManager()));
        this.addLoader(new ShaderIncludeLoader());
        this.addLoader(new PostPipelineResourceLoader());
        this.addLoader(new FramebufferResourceLoader());
        this.addLoader(new RenderTypeResourceLoader());
        this.addLoader(new TextureResourceLoader());
        this.addLoader(new McMetaResourceLoader());
        this.addLoader(new TextResourceLoader());
    }

    public void addLoader(VeilResourceLoader loader) {
        this.loaders.add((Object)loader);
    }

    private void loadPack(ResourceManager resourceManager, VeilPackResources resources, Object2ObjectMap<Path, PackResourceListener> watchers, PackType type, PackResources packResources) {
        if (packResources instanceof PackResourcesExtension) {
            PackResourcesExtension ext = (PackResourcesExtension)packResources;
            try {
                ext.veil$listResources((packType, loc, packPath, path, modResourcePath) -> {
                    if (packType != type) {
                        return;
                    }
                    try {
                        VeilResource<?> resource = this.visitResource(packType, (ResourceProvider)resourceManager, loc, path, modResourcePath);
                        resources.add(packType, loc, resource);
                        if (!resource.resourceInfo().isStatic()) {
                            Path listenPath;
                            Path path2 = listenPath = modResourcePath != null ? modResourcePath : path;
                            if (listenPath != null) {
                                try {
                                    ((PackResourceListener)watchers.computeIfAbsent((Object)packPath, PackResourceListener::new)).listen(resource, listenPath);
                                }
                                catch (Exception e) {
                                    Veil.LOGGER.error("Failed to listen to resource: {}", (Object)resource.resourceInfo().location(), (Object)e);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        Veil.LOGGER.error("Error loading resource: {}", (Object)loc, (Object)e);
                    }
                });
                return;
            }
            catch (Exception e) {
                Veil.LOGGER.error("Failed to load resources from {}", (Object)this.getClass().getSimpleName(), (Object)e);
            }
        }
        for (String namespace : packResources.getNamespaces(type)) {
            packResources.listResources(type, namespace, "", (loc, inputStreamIoSupplier) -> {
                try {
                    resources.add(type, (ResourceLocation)loc, this.visitResource(type, (ResourceProvider)resourceManager, (ResourceLocation)loc, null, null));
                }
                catch (Exception e) {
                    Veil.LOGGER.error("Error loading resource: {}", loc, (Object)e);
                }
            });
        }
    }

    private VeilResource<?> visitResource(@Nullable PackType packType, ResourceProvider provider, ResourceLocation loc, @Nullable Path path, @Nullable Path modResourcePath) throws IOException {
        for (VeilResourceLoader loader : this.loaders) {
            if (!loader.canLoad(packType, loc, path, modResourcePath)) continue;
            return loader.load(this, provider, packType, loc, path, modResourcePath);
        }
        return new UnknownResource(new VeilResourceInfo(packType, loc, path, modResourcePath, false));
    }

    public PreparableReloadListener createReloadListener() {
        return CompositeReloadListener.of(new PreparableReloadListener(){

            public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller prepareProfiler, ProfilerFiller applyProfiler, Executor backgroundExecutor, Executor gameExecutor) {
                return VeilResourceManagerImpl.this.reloadClient(preparationBarrier, resourceManager, prepareProfiler, applyProfiler, backgroundExecutor, gameExecutor);
            }

            public String getName() {
                return VeilResourceManager.class.getSimpleName() + " Client";
            }
        }, new PreparableReloadListener(){

            public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller prepareProfiler, ProfilerFiller applyProfiler, Executor backgroundExecutor, Executor gameExecutor) {
                return VeilResourceManagerImpl.this.reloadServer(preparationBarrier, resourceManager, prepareProfiler, applyProfiler, backgroundExecutor, gameExecutor);
            }

            public String getName() {
                return VeilResourceManager.class.getSimpleName() + " Server";
            }
        });
    }

    private CompletableFuture<Void> reloadClient(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            LinkedList<VeilPackResources> packs = new LinkedList<VeilPackResources>();
            Object2ObjectArrayMap watchers = new Object2ObjectArrayMap();
            resourceManager.listPacks().flatMap(pack -> {
                Stream<PackResources> stream;
                if (pack instanceof PackResourcesExtension) {
                    PackResourcesExtension extension = (PackResourcesExtension)pack;
                    stream = extension.veil$listPacks();
                } else {
                    stream = Stream.of(pack);
                }
                return stream;
            }).forEach(arg_0 -> this.lambda$reloadClient$4(resourceManager, (Object2ObjectMap)watchers, packs, arg_0));
            return new Preparations(packs, (Object2ObjectMap<Path, PackResourceListener>)watchers);
        }, backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).wait(arg_0))).thenAcceptAsync(preparations -> {
            this.free();
            this.packResources.addAll(preparations.packs());
            this.watchers.putAll(preparations.watchers());
        }, gameExecutor);
    }

    private CompletableFuture<Void> reloadServer(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            this.serverResourceManager = new MultiPackResourceManager(PackType.SERVER_DATA, resourceManager.listPacks().toList());
            return this.serverResourceManager;
        }, backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).wait(arg_0))).thenAcceptAsync(serverResourceManager -> {
            this.serverResourceManager = serverResourceManager;
        }, gameExecutor);
    }

    @Override
    public ResourceManager clientResources() {
        return Minecraft.getInstance().getResourceManager();
    }

    @Override
    public ResourceManager serverResources() {
        return this.serverResourceManager;
    }

    @Override
    @Nullable
    public VeilResource<?> getVeilResource(String namespace, String path) {
        for (VeilPackResources pack : this.packResources) {
            VeilResource<?> resource = pack.getVeilResource(namespace, path);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    public void free() {
        for (PackResourceListener listener : this.watchers.values()) {
            try {
                listener.close();
            }
            catch (IOException e) {
                Veil.LOGGER.error("Error closing watch service: {}", (Object)listener.getPath(), (Object)e);
            }
        }
        this.watchers.clear();
        for (VeilPackResources resources : this.packResources) {
            resources.free();
        }
        this.packResources.clear();
        WATCHER_ID.set(1);
    }

    public List<VeilPackResources> getAllPacks() {
        return this.packResources;
    }

    private /* synthetic */ void lambda$reloadClient$4(ResourceManager resourceManager, Object2ObjectMap watchers, List packs, PackResources pack) {
        PackResourcesExtension extension;
        IoSupplier<InputStream> icon;
        VeilPackResources resources = new VeilPackResources(pack.packId());
        this.loadPack(resourceManager, resources, (Object2ObjectMap<Path, PackResourceListener>)watchers, PackType.CLIENT_RESOURCES, pack);
        packs.add(resources);
        if (pack instanceof PackResourcesExtension && (icon = (extension = (PackResourcesExtension)pack).veil$getIcon()) != null) {
            try {
                NativeImage image = NativeImage.read((InputStream)((InputStream)icon.get()));
                RenderSystem.recordRenderCall(() -> {
                    try (NativeImage nativeImage = image;){
                        resources.loadIcon(image);
                    }
                });
            }
            catch (Exception e) {
                Veil.LOGGER.error("Failed to load icon for pack: {}", (Object)pack.packId(), (Object)e);
            }
        }
    }

    private static class PackResourceListener
    implements Closeable {
        private final Path path;
        private final WatchService watchService;
        private final ObjectSet<Path> watchedDirectories;
        private final ObjectSet<Path> ignoredPaths;
        private final Object2ObjectMap<Path, VeilResource<?>> resources;
        private final Thread watchThread;

        public PackResourceListener(Path path) {
            WatchService watchService;
            try {
                watchService = path.getFileSystem().newWatchService();
            }
            catch (Exception ignored) {
                watchService = null;
            }
            this.path = path;
            this.watchService = watchService;
            this.watchedDirectories = ObjectSets.synchronize((ObjectSet)new ObjectArraySet());
            this.ignoredPaths = ObjectSets.synchronize((ObjectSet)new ObjectArraySet());
            this.resources = new Object2ObjectOpenHashMap();
            if (this.watchService != null) {
                this.watchThread = new Thread(this::run, "Veil File Watcher Thread " + WATCHER_ID.getAndIncrement());
                this.watchThread.start();
            } else {
                this.watchThread = null;
            }
        }

        private void run() {
            while (true) {
                WatchKey key;
                try {
                    key = this.watchService.take();
                }
                catch (ClosedWatchServiceException e) {
                    return;
                }
                catch (Throwable t) {
                    Veil.LOGGER.error("Error waiting for file", t);
                    return;
                }
                for (WatchEvent<Path> watchEvent : key.pollEvents()) {
                    VeilResource resource;
                    WatchEvent.Kind<?> kind = watchEvent.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                    WatchEvent<Path> pathWatchEvent = watchEvent;
                    Path path = ((Path)key.watchable()).resolve((Path)pathWatchEvent.context());
                    if (!this.ignoredPaths.add((Object)path) || (resource = (VeilResource)this.resources.get((Object)path)) == null) continue;
                    resource.onFileSystemChange(pathWatchEvent).thenRun(() -> this.ignoredPaths.remove((Object)path));
                }
                key.reset();
            }
        }

        public void listen(VeilResource<?> resource, Path listenPath) throws IOException {
            Path folder = listenPath.getParent();
            if (folder == null) {
                return;
            }
            this.resources.put((Object)listenPath, resource);
            if (this.watchService != null && this.watchedDirectories.add((Object)folder)) {
                folder.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.watchService != null) {
                this.watchService.close();
            }
            try {
                if (this.watchThread != null) {
                    this.watchThread.join();
                }
            }
            catch (InterruptedException e) {
                throw new IOException("Failed to stop watcher thread", e);
            }
        }

        public Path getPath() {
            return this.path;
        }
    }

    private record Preparations(List<VeilPackResources> packs, Object2ObjectMap<Path, PackResourceListener> watchers) {
    }
}

