/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.framebuffer;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFboAttachment;
import foundry.veil.api.client.render.framebuffer.AdvancedFboMutableTextureAttachment;
import foundry.veil.api.client.render.framebuffer.AdvancedFboRenderAttachment;
import foundry.veil.api.client.render.framebuffer.AdvancedFboTextureAttachment;
import foundry.veil.api.client.render.framebuffer.FramebufferAttachmentDefinition;
import foundry.veil.impl.client.render.AdvancedFboImpl;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.NativeResource;

public interface AdvancedFbo
extends NativeResource {
    public void create();

    public void clear();

    public void bind(boolean var1);

    public void bindRead();

    public void bindDraw(boolean var1);

    public static AdvancedFbo getMainFramebuffer() {
        return AdvancedFboImpl.MAIN_WRAPPER;
    }

    public static void unbind() {
        RenderTarget mainTarget = Minecraft.getInstance().getMainRenderTarget();
        if (mainTarget != null) {
            mainTarget.bindWrite(true);
            return;
        }
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> GL30.glBindFramebuffer((int)36160, (int)0));
        } else {
            GL30.glBindFramebuffer((int)36160, (int)0);
        }
    }

    public static void unbindRead() {
        int mainTarget = AdvancedFbo.getMainFramebuffer().getId();
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> GL30.glBindFramebuffer((int)36008, (int)mainTarget));
        } else {
            GL30.glBindFramebuffer((int)36008, (int)mainTarget);
        }
    }

    public static void unbindDraw() {
        int mainTarget = AdvancedFbo.getMainFramebuffer().getId();
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> GL30.glBindFramebuffer((int)36009, (int)mainTarget));
        } else {
            GL30.glBindFramebuffer((int)36009, (int)mainTarget);
        }
    }

    default public void draw() {
        RenderSystem.assertOnRenderThread();
        Window window = Minecraft.getInstance().getWindow();
        this.bindRead();
        GL30.glBindFramebuffer((int)36009, (int)0);
        GL11C.glReadBuffer((int)1029);
        GL30.glBlitFramebuffer((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight(), (int)0, (int)0, (int)window.getWidth(), (int)window.getHeight(), (int)16384, (int)9729);
        GL30.glDrawBuffer((int)1028);
        AdvancedFbo.unbind();
    }

    default public void resolveToFbo(int id, int width, int height, int mask, int filtering) {
        RenderSystem.assertOnRenderThreadOrInit();
        this.bindRead();
        GL30.glBindFramebuffer((int)36009, (int)id);
        GL30.glBlitFramebuffer((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight(), (int)0, (int)0, (int)width, (int)height, (int)mask, (int)filtering);
        AdvancedFbo.unbind();
    }

    default public void resolveToAdvancedFbo(AdvancedFbo target) {
        this.resolveToFbo(target.getId(), target.getWidth(), target.getHeight(), 16640, 9728);
    }

    default public void resolveToAdvancedFbo(AdvancedFbo target, int mask, int filtering) {
        this.resolveToFbo(target.getId(), target.getWidth(), target.getHeight(), mask, filtering);
    }

    default public void resolveToFramebuffer(RenderTarget target) {
        this.resolveToFbo(target.frameBufferId, target.viewWidth, target.viewHeight, 16640, 9728);
    }

    default public void resolveToFramebuffer(RenderTarget target, int mask, int filtering) {
        this.resolveToFbo(target.frameBufferId, target.viewWidth, target.viewHeight, mask, filtering);
    }

    default public void resolveToScreen() {
        this.resolveToScreen(16384, 9728);
    }

    default public void resolveToScreen(int mask, int filtering) {
        RenderSystem.assertOnRenderThreadOrInit();
        Window window = Minecraft.getInstance().getWindow();
        this.bindRead();
        AdvancedFbo.unbindDraw();
        GL30.glBlitFramebuffer((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight(), (int)0, (int)0, (int)window.getWidth(), (int)window.getHeight(), (int)mask, (int)filtering);
        AdvancedFbo.unbindRead();
    }

    public int getId();

    public int getWidth();

    public int getHeight();

    public int getColorAttachments();

    public int getClearMask();

    public int[] getDrawBuffers();

    public boolean hasColorAttachment(int var1);

    public boolean hasDepthAttachment();

    public AdvancedFboAttachment getColorAttachment(int var1);

    default public boolean isColorTextureAttachment(int attachment) {
        return this.hasColorAttachment(attachment) && this.getColorAttachment(attachment) instanceof AdvancedFboTextureAttachment;
    }

    default public boolean isMutableColorTextureAttachment(int attachment) {
        return this.hasColorAttachment(attachment) && this.getColorAttachment(attachment) instanceof AdvancedFboMutableTextureAttachment;
    }

    default public boolean isColorRenderAttachment(int attachment) {
        return this.hasColorAttachment(attachment) && this.getColorAttachment(attachment) instanceof AdvancedFboRenderAttachment;
    }

    default public AdvancedFboTextureAttachment getColorTextureAttachment(int attachment) {
        AdvancedFboAttachment advancedFboAttachment = this.getColorAttachment(attachment);
        Validate.isTrue((boolean)this.isColorTextureAttachment(attachment), (String)("Color attachment " + attachment + " must be a texture attachment to get texture information."), (Object[])new Object[0]);
        return (AdvancedFboTextureAttachment)advancedFboAttachment;
    }

    default public void setColorAttachmentTexture(int attachment, int textureId) {
        this.setColorAttachmentTexture(attachment, textureId, -1);
    }

    default public void setColorAttachmentTexture(int attachment, int textureId, int layer) {
        AdvancedFboAttachment advancedFboAttachment = this.getColorAttachment(attachment);
        Validate.isTrue((boolean)this.isMutableColorTextureAttachment(attachment), (String)("Color attachment " + attachment + " must be a mutable texture attachment to modify texture information."), (Object[])new Object[0]);
        AdvancedFboMutableTextureAttachment mutableTextureAttachment = (AdvancedFboMutableTextureAttachment)advancedFboAttachment;
        mutableTextureAttachment.setTexture(textureId, layer);
        mutableTextureAttachment.attach(attachment);
    }

    default public AdvancedFboRenderAttachment getColorRenderAttachment(int attachment) {
        AdvancedFboAttachment advancedFboAttachment = this.getColorAttachment(attachment);
        Validate.isTrue((boolean)this.isColorRenderAttachment(attachment), (String)("Color attachment " + attachment + " must be a render attachment to get render information."), (Object[])new Object[0]);
        return (AdvancedFboRenderAttachment)advancedFboAttachment;
    }

    public AdvancedFboAttachment getDepthAttachment();

    default public boolean isDepthTextureAttachment() {
        return this.hasDepthAttachment() && this.getDepthAttachment() instanceof AdvancedFboTextureAttachment;
    }

    default public boolean isDepthMutableTextureAttachment() {
        return this.hasDepthAttachment() && this.getDepthAttachment() instanceof AdvancedFboMutableTextureAttachment;
    }

    default public boolean isDepthRenderAttachment() {
        return this.hasDepthAttachment() && this.getDepthAttachment() instanceof AdvancedFboRenderAttachment;
    }

    default public AdvancedFboTextureAttachment getDepthTextureAttachment() {
        AdvancedFboAttachment advancedFboAttachment = this.getDepthAttachment();
        Validate.isTrue((boolean)this.isDepthTextureAttachment(), (String)"Depth attachment must be a texture attachment to get texture information.", (Object[])new Object[0]);
        return (AdvancedFboTextureAttachment)advancedFboAttachment;
    }

    default public void setDepthAttachmentTexture(int textureId) {
        this.setDepthAttachmentTexture(textureId, -1);
    }

    default public void setDepthAttachmentTexture(int textureId, int layer) {
        AdvancedFboAttachment advancedFboAttachment = this.getDepthAttachment();
        Validate.isTrue((boolean)this.isDepthMutableTextureAttachment(), (String)"Depth attachment must be a mutable texture attachment to modify texture information.", (Object[])new Object[0]);
        AdvancedFboMutableTextureAttachment mutableTextureAttachment = (AdvancedFboMutableTextureAttachment)advancedFboAttachment;
        mutableTextureAttachment.setTexture(textureId, layer);
        mutableTextureAttachment.attach(0);
    }

    default public AdvancedFboRenderAttachment getDepthRenderAttachment() {
        AdvancedFboAttachment advancedFboAttachment = this.getDepthAttachment();
        Validate.isTrue((boolean)this.isDepthRenderAttachment(), (String)"Depth attachment must be a render attachment to get render information.", (Object[])new Object[0]);
        return (AdvancedFboRenderAttachment)advancedFboAttachment;
    }

    public RenderTarget toRenderTarget();

    public static Builder withSize(int width, int height) {
        return new Builder(width, height);
    }

    public static Builder copy(AdvancedFbo parent) {
        return new Builder(parent.getWidth(), parent.getHeight()).addAttachments(parent);
    }

    public static Builder copy(RenderTarget parent) {
        return AdvancedFboImpl.copy(parent);
    }

    public static class Builder {
        private final int width;
        private final int height;
        private final List<AdvancedFboAttachment> colorAttachments;
        private AdvancedFboAttachment depthAttachment;
        private int mipmaps;
        private int samples;
        private int format;
        private int internalFormat;
        private boolean linear;
        private String name;

        public Builder(int width, int height) {
            this.width = width;
            this.height = height;
            this.colorAttachments = new LinkedList<AdvancedFboAttachment>();
            this.depthAttachment = null;
            this.mipmaps = 0;
            this.samples = 1;
            this.format = 6408;
            this.internalFormat = 32856;
            this.linear = false;
            this.name = null;
        }

        private void validateColorSize() {
            Validate.inclusiveBetween((long)0L, (long)VeilRenderSystem.maxColorAttachments(), (long)this.colorAttachments.size());
        }

        private void validateSamples() {
            int samples = -1;
            for (AdvancedFboAttachment attachment : this.colorAttachments) {
                if (!(attachment instanceof AdvancedFboRenderAttachment)) continue;
                if (samples == -1) {
                    samples = attachment.getLevels();
                    continue;
                }
                if (attachment.getLevels() == samples) continue;
                throw new IllegalArgumentException("Framebuffer attachments need to have the same number of samples to be complete.");
            }
            if (samples != -1 && this.depthAttachment instanceof AdvancedFboRenderAttachment && this.depthAttachment.getLevels() != samples) {
                throw new IllegalArgumentException("Framebuffer attachments need to have the same number of samples to be complete.");
            }
        }

        public Builder addAttachments(AdvancedFbo parent) {
            for (int i = 0; i < parent.getColorAttachments(); ++i) {
                this.colorAttachments.add(parent.getColorAttachment(i).clone());
            }
            this.validateColorSize();
            if (parent.hasDepthAttachment()) {
                Validate.isTrue((this.depthAttachment == null ? 1 : 0) != 0, (String)"Only one depth attachment can be applied to an FBO.", (Object[])new Object[0]);
                this.depthAttachment = parent.getDepthAttachment().clone();
            }
            return this;
        }

        public Builder addAttachments(RenderTarget parent) {
            this.setMipmaps(0);
            this.addColorTextureBuffer(parent.width, parent.height, 5121);
            if (parent.useDepth) {
                Validate.isTrue((this.depthAttachment == null ? 1 : 0) != 0, (String)"Only one depth attachment can be applied to an FBO.", (Object[])new Object[0]);
                this.setSamples(1);
                this.setDepthRenderBuffer(parent.width, parent.height);
            }
            return this;
        }

        public Builder setMipmaps(int mipmaps) {
            this.mipmaps = mipmaps;
            return this;
        }

        public Builder setSamples(int samples) {
            this.samples = samples;
            return this;
        }

        public Builder setFormat(FramebufferAttachmentDefinition.Format format) {
            return this.setFormat(format.getId(), format.getInternalId());
        }

        public Builder setFormat(int format, int internalFormat) {
            this.format = format;
            this.internalFormat = internalFormat;
            return this;
        }

        public Builder setLinear(boolean linear) {
            this.linear = linear;
            return this;
        }

        public Builder setName(@Nullable String name) {
            this.name = name;
            return this;
        }

        public Builder addColorBuffer(AdvancedFboAttachment attachment) {
            this.colorAttachments.add(attachment);
            this.name = null;
            this.validateColorSize();
            return this;
        }

        public Builder addColorTextureWrapper(int textureId) {
            return this.addColorTextureWrapper(textureId, -1);
        }

        public Builder addColorTextureWrapper(int textureId, int layer) {
            return this.addColorBuffer(new AdvancedFboMutableTextureAttachment(36064, textureId, layer));
        }

        public Builder addColorTextureBuffer() {
            return this.addColorTextureBuffer(this.width, this.height, 5121);
        }

        public Builder addColorTextureBuffer(int width, int height) {
            return this.addColorTextureBuffer(width, height, 5121);
        }

        public Builder addColorTextureBuffer(int dataType) {
            return this.addColorTextureBuffer(this.width, this.height, dataType);
        }

        public Builder addColorTextureBuffer(int width, int height, int dataType) {
            return this.addColorBuffer(new AdvancedFboTextureAttachment(36064, this.internalFormat, this.format, dataType, width, height, this.mipmaps, this.linear, this.name));
        }

        public Builder addColorRenderBuffer() {
            return this.addColorRenderBuffer(this.width, this.height);
        }

        public Builder addColorRenderBuffer(int width, int height) {
            return this.addColorBuffer(new AdvancedFboRenderAttachment(36064, this.format, width, height, this.samples));
        }

        public Builder setDepthBuffer(@Nullable AdvancedFboAttachment attachment) {
            Validate.isTrue((attachment == null || this.depthAttachment == null ? 1 : 0) != 0, (String)"Only one depth attachment can be applied to an FBO.", (Object[])new Object[0]);
            this.depthAttachment = attachment;
            this.name = null;
            return this;
        }

        public Builder setDepthTextureWrapper(int textureId) {
            return this.setDepthTextureWrapper(textureId, -1);
        }

        public Builder setDepthTextureWrapper(int textureId, int layer) {
            return this.setDepthBuffer(new AdvancedFboMutableTextureAttachment(36096, textureId, layer));
        }

        public Builder setDepthTextureBuffer() {
            return this.setDepthTextureBuffer(this.width, this.height, 5126);
        }

        public Builder setDepthTextureBuffer(int width, int height) {
            return this.setDepthTextureBuffer(width, height, 5126);
        }

        public Builder setDepthTextureBuffer(int dataType) {
            return this.setDepthTextureBuffer(this.width, this.height, dataType);
        }

        public Builder setDepthTextureBuffer(int width, int height, int dataType) {
            return this.setDepthBuffer(new AdvancedFboTextureAttachment(36096, this.internalFormat, this.format, dataType, width, height, this.mipmaps, this.linear, this.name));
        }

        public Builder setDepthRenderBuffer() {
            return this.setDepthRenderBuffer(this.width, this.height);
        }

        public Builder setDepthRenderBuffer(int width, int height) {
            return this.setDepthBuffer(new AdvancedFboRenderAttachment(36096, 33190, width, height, this.samples));
        }

        public AdvancedFbo build(boolean create) {
            if (this.colorAttachments.isEmpty()) {
                throw new IllegalArgumentException("Framebuffer needs at least one color attachment to be complete.");
            }
            if (this.width <= 0 || this.height <= 0) {
                throw new IllegalArgumentException("Framebuffer needs a positive area to be complete. (Was " + this.width + "x" + this.height + ")");
            }
            this.validateSamples();
            AdvancedFboImpl framebuffer = new AdvancedFboImpl(this.width, this.height, this.colorAttachments.toArray(new AdvancedFboAttachment[0]), this.depthAttachment);
            if (create) {
                framebuffer.create();
            }
            return framebuffer;
        }
    }
}

