/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.registry;

import com.mojang.serialization.MapCodec;
import foundry.veil.Veil;
import foundry.veil.api.client.render.post.PostPipeline;
import foundry.veil.api.client.render.post.stage.BlitPostStage;
import foundry.veil.api.client.render.post.stage.CopyPostStage;
import foundry.veil.api.client.render.post.stage.DepthFunctionPostStage;
import foundry.veil.api.client.render.post.stage.MaskPostStage;
import foundry.veil.platform.registry.RegistrationProvider;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

public class PostPipelineStageRegistry {
    public static final ResourceKey<Registry<PipelineType<?>>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)Veil.veilPath("post_pipeline_stage"));
    private static final RegistrationProvider<PipelineType<?>> PROVIDER = RegistrationProvider.get(REGISTRY_KEY, "veil");
    public static final Registry<PipelineType<?>> REGISTRY = PROVIDER.asVanillaRegistry();
    public static final Supplier<PipelineType<BlitPostStage>> BLIT = PostPipelineStageRegistry.register("blit", BlitPostStage.CODEC);
    public static final Supplier<PipelineType<CopyPostStage>> COPY = PostPipelineStageRegistry.register("copy", CopyPostStage.CODEC);
    public static final Supplier<PipelineType<MaskPostStage>> MASK = PostPipelineStageRegistry.register("mask", MaskPostStage.CODEC);
    public static final Supplier<PipelineType<DepthFunctionPostStage>> DEPTH_FUNC = PostPipelineStageRegistry.register("depth_function", DepthFunctionPostStage.CODEC);

    @ApiStatus.Internal
    public static void bootstrap() {
    }

    private static <T extends PostPipeline> Supplier<PipelineType<T>> register(String name, MapCodec<T> codec) {
        return PROVIDER.register(name, () -> new PipelineType(codec));
    }

    public record PipelineType<T extends PostPipeline>(MapCodec<T> codec) {
    }
}

