/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader;

import foundry.veil.api.client.render.shader.definition.ShaderPreDefinitions;
import foundry.veil.api.client.render.shader.processor.ShaderCustomProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderModifyProcessor;
import foundry.veil.api.client.render.shader.processor.ShaderPreProcessor;
import foundry.veil.api.client.render.shader.program.ProgramDefinition;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class SimpleShaderProcessor {
    private static ShaderPreProcessor processor;

    public static void setup(ResourceProvider resourceProvider) {
        processor = ShaderPreProcessor.allOf(new ShaderModifyProcessor(), new ShaderCustomProcessor(resourceProvider));
    }

    public static void free() {
        processor = null;
    }

    public static String modify(@Nullable ResourceLocation name, String source) throws IOException {
        if (processor == null) {
            throw new NullPointerException("Processor not initialized");
        }
        return processor.modify(new Context(name), source);
    }

    private record Context(ResourceLocation name) implements ShaderPreProcessor.Context
    {
        @Override
        public String modify(@Nullable ResourceLocation name, String source) throws IOException {
            return processor.modify(new Context(name), source);
        }

        @Override
        public void addUniformBinding(String name, int binding) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addDefinitionDependency(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addInclude(ResourceLocation name) {
        }

        @Override
        public Set<ResourceLocation> includes() {
            return Collections.emptySet();
        }

        @Override
        public boolean isSourceFile() {
            return true;
        }

        @Override
        @Nullable
        public ProgramDefinition definition() {
            return null;
        }

        @Override
        @Nullable
        public ShaderPreDefinitions preDefinitions() {
            return null;
        }
    }
}

