/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.mixin.client.shader;

import com.mojang.blaze3d.shaders.Program;
import com.mojang.blaze3d.shaders.Uniform;
import foundry.veil.impl.client.render.shader.ShaderProgramImpl;
import foundry.veil.impl.client.render.shader.SimpleShaderProcessor;
import foundry.veil.impl.client.render.wrapper.VanillaUniformWrapper;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.lwjgl.opengl.GL20C;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ShaderInstance.class})
public class ShaderInstanceMixin {
    @Shadow
    @Final
    private int programId;
    @Shadow
    @Final
    private List<Integer> uniformLocations;
    @Shadow
    @Final
    public Map<String, Uniform> uniformMap;
    @Unique
    private final Set<String> veil$invalidUniforms = new HashSet<String>();

    @Inject(method={"getOrCreate"}, at={@At(value="HEAD")}, cancellable=true)
    private static void veil$cancelDummyProgram(ResourceProvider provider, Program.Type type, String name, CallbackInfoReturnable<Program> cir) {
        if (ShaderProgramImpl.Wrapper.constructing) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"getOrCreate"}, at={@At(value="HEAD")})
    private static void veil$setupFallbackProcessor(ResourceProvider provider, Program.Type type, String name, CallbackInfoReturnable<Program> cir) {
        SimpleShaderProcessor.setup(provider);
    }

    @Inject(method={"getOrCreate"}, at={@At(value="RETURN")})
    private static void veil$clearFallbackProcessor(ResourceProvider provider, Program.Type type, String name, CallbackInfoReturnable<Program> cir) {
        SimpleShaderProcessor.free();
    }

    @Inject(method={"getUniform"}, at={@At(value="RETURN")}, cancellable=true)
    public void getUniform(String name, CallbackInfoReturnable<Uniform> cir) {
        if (cir.getReturnValue() == null && !this.veil$invalidUniforms.contains(name)) {
            int location = GL20C.glGetUniformLocation((int)this.programId, (CharSequence)name);
            if (location == -1) {
                this.veil$invalidUniforms.add(name);
                return;
            }
            VanillaUniformWrapper uniform = new VanillaUniformWrapper(this.programId, name);
            this.uniformLocations.add(location);
            uniform.setLocation(location);
            this.uniformMap.put(name, uniform);
            cir.setReturnValue((Object)uniform);
        }
    }

    @Inject(method={"updateLocations"}, at={@At(value="TAIL")})
    public void updateLocations(CallbackInfo ci) {
        this.veil$invalidUniforms.clear();
    }
}

