/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.glsl.grammar;

import foundry.veil.impl.glsl.node.GlslNode;
import java.util.Arrays;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public sealed interface GlslTypeQualifier {
    public String getSourceString();

    public static GlslTypeQualifier storage(String[] typeNames) {
        return new StorageSubroutine(typeNames);
    }

    public static Layout layout(LayoutId ... ids) {
        return new Layout(ids);
    }

    public static LayoutId identifierLayoutId(String identifier, @Nullable GlslNode constantExpression) {
        return new LayoutId(identifier, constantExpression);
    }

    public static LayoutId sharedLayoutId() {
        return new LayoutId("shared", null);
    }

    public record StorageSubroutine(String[] typeNames) implements GlslTypeQualifier
    {
        @Override
        public String toString() {
            return "Storage[operand=SUBROUTINE, typeNames=" + Arrays.toString(this.typeNames) + "]";
        }

        @Override
        public String getSourceString() {
            if (this.typeNames.length > 0) {
                return "subroutine(" + String.join((CharSequence)",", this.typeNames) + ")";
            }
            return "subroutine";
        }
    }

    public record Layout(LayoutId[] layoutIds) implements GlslTypeQualifier
    {
        @Override
        public String getSourceString() {
            StringBuilder builder = new StringBuilder();
            for (LayoutId layoutId : this.layoutIds) {
                if (layoutId.shared()) {
                    builder.append("shared ");
                    continue;
                }
                builder.append(layoutId.identifier());
                GlslNode expression = layoutId.expression();
                if (expression != null) {
                    builder.append(" = ").append(expression.getSourceString());
                }
                builder.append(", ");
            }
            builder.delete(builder.length() - 2, builder.length());
            return "layout(" + String.valueOf(builder) + ")";
        }
    }

    public record LayoutId(String identifier, @Nullable GlslNode expression) {
        public boolean shared() {
            return "shared".equals(this.identifier);
        }
    }

    public static enum Precise implements GlslTypeQualifier
    {
        PRECISE;


        @Override
        public String getSourceString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum Invariant implements GlslTypeQualifier
    {
        INVARIANT;


        @Override
        public String getSourceString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum Interpolation implements GlslTypeQualifier
    {
        SMOOTH,
        FLAT,
        NOPERSPECTIVE;


        @Override
        public String getSourceString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum Precision implements GlslTypeQualifier
    {
        HIGH_PRECISION("highp"),
        MEDIUM_PRECISION("mediump"),
        LOW_PRECISION("lowp");

        private final String sourceName;

        private Precision(String sourceName) {
            this.sourceName = sourceName;
        }

        @Override
        public String getSourceString() {
            return this.sourceName;
        }
    }

    public static enum StorageType implements GlslTypeQualifier
    {
        CONST,
        IN,
        OUT,
        INOUT,
        CENTROID,
        PATCH,
        SAMPLE,
        UNIFORM,
        BUFFER,
        SHARED,
        COHERENT,
        VOLATILE,
        RESTRICT,
        READONLY,
        WRITEONLY;


        @Override
        public String getSourceString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

