/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.glsl.grammar;

import foundry.veil.impl.glsl.grammar.GlslParameterDeclaration;
import foundry.veil.impl.glsl.grammar.GlslSpecifiedType;
import foundry.veil.impl.glsl.grammar.GlslType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class GlslFunctionHeader {
    private String name;
    private GlslSpecifiedType returnType;
    private final List<GlslParameterDeclaration> parameters;

    public GlslFunctionHeader(String name, GlslType returnType, Collection<GlslParameterDeclaration> parameters) {
        this.name = name;
        this.returnType = returnType.asSpecifiedType();
        this.parameters = new ArrayList<GlslParameterDeclaration>(parameters);
    }

    public GlslFunctionHeader withParameters(GlslParameterDeclaration ... parameters) {
        return new GlslFunctionHeader(this.name, this.returnType, new ArrayList<GlslParameterDeclaration>(Arrays.asList(parameters)));
    }

    public String getName() {
        return this.name;
    }

    public GlslSpecifiedType getReturnType() {
        return this.returnType;
    }

    public List<GlslParameterDeclaration> getParameters() {
        return this.parameters;
    }

    public GlslFunctionHeader setName(String name) {
        this.name = name;
        return this;
    }

    public GlslFunctionHeader setReturnType(GlslType returnType) {
        this.returnType = returnType.asSpecifiedType();
        return this;
    }

    public String toString() {
        return "GlslFunctionHeader{name='" + this.name + "', returnType=" + String.valueOf(this.returnType) + ", parameters=" + String.valueOf(this.parameters) + "}";
    }

    public String getSourceString() {
        return this.returnType.getSourceString() + " " + this.name + "(" + this.parameters.stream().map(parameter -> {
            String name = parameter.getName();
            if (name != null) {
                return parameter.getType().getSourceString() + " " + name;
            }
            return parameter.getType().getSourceString();
        }).collect(Collectors.joining(", ")) + ")";
    }
}

