/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.util;

import net.minecraft.util.Mth;

public enum Easing {
    LINEAR{

        @Override
        public float ease(float x) {
            return x;
        }
    }
    ,
    EASE_IN_QUAD{

        @Override
        public float ease(float x) {
            return x * x;
        }
    }
    ,
    EASE_OUT_QUAD{

        @Override
        public float ease(float x) {
            return 1.0f - (1.0f - x) * (1.0f - x);
        }
    }
    ,
    EASE_IN_OUT_QUAD{

        @Override
        public float ease(float x) {
            return (double)x < 0.5 ? 2.0f * x * x : (float)(1.0 - Math.pow(-2.0f * x + 2.0f, 2.0) / 2.0);
        }
    }
    ,
    EASE_IN_CUBIC{

        @Override
        public float ease(float x) {
            return x * x * x;
        }
    }
    ,
    EASE_OUT_CUBIC{

        @Override
        public float ease(float x) {
            return (float)(1.0 - Math.pow(1.0f - x, 3.0));
        }
    }
    ,
    EASE_IN_OUT_CUBIC{

        @Override
        public float ease(float x) {
            return (double)x < 0.5 ? 4.0f * x * x * x : (float)(1.0 - Math.pow(-2.0f * x + 2.0f, 3.0) / 2.0);
        }
    }
    ,
    EASE_IN_QUART{

        @Override
        public float ease(float x) {
            return x * x * x * x;
        }
    }
    ,
    EASE_OUT_QUART{

        @Override
        public float ease(float x) {
            return (float)(1.0 - Math.pow(1.0f - x, 4.0));
        }
    }
    ,
    EASE_IN_OUT_QUART{

        @Override
        public float ease(float x) {
            return (double)x < 0.5 ? 8.0f * x * x * x * x : (float)(1.0 - Math.pow(-2.0f * x + 2.0f, 4.0) / 2.0);
        }
    }
    ,
    EASE_IN_QUINT{

        @Override
        public float ease(float x) {
            return x * x * x * x * x;
        }
    }
    ,
    EASE_OUT_QUINT{

        @Override
        public float ease(float x) {
            return (float)(1.0 - Math.pow(1.0f - x, 5.0));
        }
    }
    ,
    EASE_IN_OUT_QUINT{

        @Override
        public float ease(float x) {
            return (double)x < 0.5 ? 16.0f * x * x * x * x * x : (float)(1.0 - Math.pow(-2.0f * x + 2.0f, 5.0) / 2.0);
        }
    }
    ,
    EASE_IN_SINE{

        @Override
        public float ease(float x) {
            return 1.0f - Mth.cos((float)((float)((double)x * Math.PI / 2.0)));
        }
    }
    ,
    EASE_OUT_SINE{

        @Override
        public float ease(float x) {
            return Mth.sin((float)((float)((double)x * Math.PI / 2.0)));
        }
    }
    ,
    EASE_IN_OUT_SINE{

        @Override
        public float ease(float x) {
            return -(Mth.cos((float)((float)(Math.PI * (double)x))) - 1.0f) / 2.0f;
        }
    }
    ,
    EASE_IN_EXPO{

        @Override
        public float ease(float x) {
            return x == 0.0f ? 0.0f : (float)Math.pow(2.0, 10.0f * x - 10.0f);
        }
    }
    ,
    EASE_OUT_EXPO{

        @Override
        public float ease(float x) {
            return x == 1.0f ? 1.0f : (float)(1.0 - Math.pow(2.0, -10.0f * x));
        }
    }
    ,
    EASE_IN_OUT_EXPO{

        @Override
        public float ease(float x) {
            return x == 0.0f ? 0.0f : (float)(x == 1.0f ? 1.0 : ((double)x < 0.5 ? Math.pow(2.0, 20.0f * x - 10.0f) / 2.0 : (2.0 - Math.pow(2.0, -20.0f * x + 10.0f)) / 2.0));
        }
    }
    ,
    EASE_IN_CIRC{

        @Override
        public float ease(float x) {
            return (float)(1.0 - Math.sqrt(1.0 - Math.pow(x, 2.0)));
        }
    }
    ,
    EASE_OUT_CIRC{

        @Override
        public float ease(float x) {
            return (float)Math.sqrt(1.0 - Math.pow(x - 1.0f, 2.0));
        }
    }
    ,
    EASE_IN_OUT_CIRC{

        @Override
        public float ease(float x) {
            return (float)((double)x < 0.5 ? (1.0 - Math.sqrt(1.0 - Math.pow(2.0f * x, 2.0))) / 2.0 : (Math.sqrt(1.0 - Math.pow(-2.0f * x + 2.0f, 2.0)) + 1.0) / 2.0);
        }
    }
    ,
    EASE_IN_BACK{

        @Override
        public float ease(float x) {
            return 2.70158f * x * x * x - 1.70158f * x * x;
        }
    }
    ,
    EASE_OUT_BACK{

        @Override
        public float ease(float x) {
            return (float)(1.0 + (double)2.70158f * Math.pow(x - 1.0f, 3.0) + (double)1.70158f * Math.pow(x - 1.0f, 2.0));
        }
    }
    ,
    EASE_IN_OUT_BACK{

        @Override
        public float ease(float x) {
            return (float)((double)x < 0.5 ? Math.pow(2.0f * x, 2.0) * (double)(7.189819f * x - 2.5949094f) / 2.0 : (Math.pow(2.0f * x - 2.0f, 2.0) * (double)(3.5949094f * (x * 2.0f - 2.0f) + 2.5949094f) + 2.0) / 2.0);
        }
    }
    ,
    EASE_IN_ELASTIC{

        @Override
        public float ease(float x) {
            return x == 0.0f ? 0.0f : (float)(x == 1.0f ? 1.0 : -Math.pow(2.0, 10.0f * x - 10.0f) * (double)Mth.sin((float)((float)(((double)(x * 10.0f) - 10.75) * 2.0943951023931953))));
        }
    }
    ,
    EASE_OUT_ELASTIC{

        @Override
        public float ease(float x) {
            return x == 0.0f ? 0.0f : (float)(x == 1.0f ? 1.0 : Math.pow(2.0, -10.0f * x) * (double)Mth.sin((float)((float)(((double)(x * 10.0f) - 0.75) * 2.0943951023931953))) + 1.0);
        }
    }
    ,
    EASE_IN_OUT_ELASTIC{

        @Override
        public float ease(float x) {
            return x == 0.0f ? 0.0f : (float)(x == 1.0f ? 1.0 : ((double)x < 0.5 ? -(Math.pow(2.0, 20.0f * x - 10.0f) * (double)Mth.sin((float)((float)(((double)(20.0f * x) - 11.125) * 1.3962634015954636)))) / 2.0 : Math.pow(2.0, -20.0f * x + 10.0f) * (double)Mth.sin((float)((float)(((double)(20.0f * x) - 11.125) * 1.3962634015954636))) / 2.0 + 1.0));
        }
    }
    ,
    EASE_IN_BOUNCE{

        @Override
        public float ease(float x) {
            return 1.0f - Easing.bounceOut(1.0f - x);
        }
    }
    ,
    EASE_OUT_BOUNCE{

        @Override
        public float ease(float x) {
            return 1.0f - Easing.bounceOut(1.0f - x);
        }
    }
    ,
    EASE_IN_OUT_BOUNCE{

        @Override
        public float ease(float x) {
            return (double)x < 0.5 ? (1.0f - Easing.bounceOut(1.0f - 2.0f * x)) / 2.0f : (1.0f + Easing.bounceOut(2.0f * x - 1.0f)) / 2.0f;
        }
    };


    public abstract float ease(float var1);

    private static float bounceOut(float x) {
        float n1 = 7.5625f;
        float d1 = 2.75f;
        if (x < 1.0f / d1) {
            return n1 * x * x;
        }
        if (x < 2.0f / d1) {
            return n1 * (x -= 1.5f / d1) * x + 0.75f;
        }
        if ((double)x < 2.5 / (double)d1) {
            return n1 * (x -= 2.25f / d1) * x + 0.9375f;
        }
        return n1 * (x -= 2.625f / d1) * x + 0.984375f;
    }
}

