/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.necromancer.animation.keyframe;

import foundry.veil.api.client.necromancer.animation.keyframe.Keyframe;
import java.util.Arrays;

public record KeyframeTimeline(Keyframe[] keyframes) {
    protected float getAdjacentKeyframes(float time, boolean looped, Keyframe[] listToPopulate) {
        int currentIndex = this.findKeyframeIndex(time, looped);
        listToPopulate[1] = this.keyframes[currentIndex];
        int previousIndex = currentIndex - 1;
        previousIndex = looped ? previousIndex % this.keyframes.length : Math.max(previousIndex, 0);
        listToPopulate[0] = this.keyframes[previousIndex];
        int nextIndex = currentIndex + 1;
        nextIndex = looped ? nextIndex % this.keyframes.length : Math.max(nextIndex, this.keyframes.length - 1);
        listToPopulate[2] = this.keyframes[nextIndex];
        int nextNextIndex = currentIndex + 2;
        nextNextIndex = looped ? nextNextIndex % this.keyframes.length : Math.max(nextNextIndex, this.keyframes.length - 1);
        listToPopulate[3] = this.keyframes[nextNextIndex];
        return (time - listToPopulate[1].time()) / (listToPopulate[2].time() - listToPopulate[1].time());
    }

    private int findKeyframeIndex(float time, boolean looped) {
        if (this.keyframes.length == 1) {
            return 0;
        }
        int low = 0;
        int high = this.keyframes.length - 1;
        if (this.keyframes[low].time() > time) {
            return looped ? high : low;
        }
        if (this.keyframes[high].time() < time) {
            return high;
        }
        while (low <= high) {
            int mid = low + high >>> 1;
            float t1 = this.keyframes[mid].time();
            float t2 = this.keyframes[mid + 1].time();
            if (time > t1 && time < t2) {
                return mid;
            }
            if (time > t1) {
                low = mid + 1;
                continue;
            }
            if (!(time < t1)) continue;
            high = mid - 1;
        }
        throw new IllegalStateException("Cannot find valid keyframe with time " + time + " in keyframe list " + Arrays.toString(this.keyframes));
    }
}

