/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.vertex;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.vertex.VertexArray;
import foundry.veil.api.client.render.vertex.VertexArrayBuilder;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.ARBDirectStateAccess;

@ApiStatus.Internal
public record DSAVertexAttribBindingBuilder(VertexArray vertexArray, int vao) implements VertexArrayBuilder
{
    @Override
    public VertexArrayBuilder defineVertexBuffer(int index, int buffer, int offset, int stride, int divisor) {
        ARBDirectStateAccess.glVertexArrayVertexBuffer((int)this.vao, (int)index, (int)buffer, (long)offset, (int)stride);
        ARBDirectStateAccess.glVertexArrayBindingDivisor((int)this.vao, (int)index, (int)divisor);
        return this;
    }

    @Override
    public VertexArrayBuilder setVertexAttribute(int index, int bufferIndex, int size, VertexArrayBuilder.DataType type, boolean normalized, int relativeOffset) {
        VertexArrayBuilder.validateRelativeOffset(relativeOffset);
        ARBDirectStateAccess.glEnableVertexArrayAttrib((int)this.vao, (int)index);
        ARBDirectStateAccess.glVertexArrayAttribFormat((int)this.vao, (int)index, (int)size, (int)type.getGlType(), (boolean)normalized, (int)relativeOffset);
        ARBDirectStateAccess.glVertexArrayAttribBinding((int)this.vao, (int)index, (int)bufferIndex);
        return this;
    }

    @Override
    public VertexArrayBuilder setVertexIAttribute(int index, int bufferIndex, int size, VertexArrayBuilder.DataType type, int relativeOffset) {
        VertexArrayBuilder.validateRelativeOffset(relativeOffset);
        ARBDirectStateAccess.glEnableVertexArrayAttrib((int)this.vao, (int)index);
        ARBDirectStateAccess.glVertexArrayAttribIFormat((int)this.vao, (int)index, (int)size, (int)type.getGlType(), (int)relativeOffset);
        ARBDirectStateAccess.glVertexArrayAttribBinding((int)this.vao, (int)index, (int)bufferIndex);
        return this;
    }

    @Override
    public VertexArrayBuilder setVertexLAttribute(int index, int bufferIndex, int size, VertexArrayBuilder.DataType type, int relativeOffset) {
        if (!VeilRenderSystem.vertexAttribute64BitSupported()) {
            throw new UnsupportedOperationException("Long attributes not supported");
        }
        VertexArrayBuilder.validateRelativeOffset(relativeOffset);
        ARBDirectStateAccess.glEnableVertexArrayAttrib((int)this.vao, (int)index);
        ARBDirectStateAccess.glVertexArrayAttribLFormat((int)this.vao, (int)index, (int)size, (int)type.getGlType(), (int)relativeOffset);
        ARBDirectStateAccess.glVertexArrayAttribBinding((int)this.vao, (int)index, (int)bufferIndex);
        return this;
    }

    @Override
    public VertexArrayBuilder removeVertexBuffer(int index) {
        ARBDirectStateAccess.glVertexArrayVertexBuffer((int)this.vao, (int)index, (int)0, (long)0L, (int)0);
        return this;
    }

    @Override
    public VertexArrayBuilder removeAttribute(int index) {
        ARBDirectStateAccess.glDisableVertexArrayAttrib((int)this.vao, (int)index);
        return this;
    }

    @Override
    public VertexArrayBuilder clearVertexBuffers() {
        for (int i = 0; i < VeilRenderSystem.maxVertexAttributes(); ++i) {
            ARBDirectStateAccess.glVertexArrayVertexBuffer((int)this.vao, (int)i, (int)0, (long)0L, (int)0);
        }
        return this;
    }

    @Override
    public VertexArrayBuilder clearVertexAttributes() {
        for (int i = 0; i < VeilRenderSystem.maxVertexAttributes(); ++i) {
            ARBDirectStateAccess.glDisableVertexArrayAttrib((int)this.vao, (int)i);
        }
        return this;
    }
}

