/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.perspective;

import foundry.veil.impl.client.render.perspective.LevelPerspectiveCamera;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.ViewArea;
import net.minecraft.client.renderer.chunk.SectionRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class VeilSectionOcclusionGraph {
    private static final Direction[] DIRECTIONS = Direction.values();
    private static final int MINIMUM_ADVANCED_CULLING_DISTANCE = 60;
    private static final double CEILED_SECTION_DIAGONAL = Math.ceil(Math.sqrt(3.0) * 16.0);
    private final NodeQueue nodeQueue = new NodeQueue(64);
    private ViewArea viewArea;
    private int viewDistance;

    public void update(ViewArea viewArea, boolean smartCull, LevelPerspectiveCamera camera, Frustum frustum, List<SectionRenderDispatcher.RenderSection> sections) {
        this.viewArea = viewArea;
        this.viewDistance = Math.min(viewArea.getViewDistance(), Mth.ceil((float)camera.getRenderDistance()));
        GraphStorage graphState = new GraphStorage(viewArea.sections.length);
        this.initializeQueueForFullUpdate(camera, viewArea);
        this.nodeQueue.forEach((Consumer<? super Node>)((Consumer<Node>)node -> graphState.sectionToNodeMap.put(node.section, (Node)node)));
        this.runUpdates(graphState, viewArea, camera.getPosition(), frustum, this.nodeQueue, smartCull, sections);
    }

    public void reset() {
        this.nodeQueue.trim(64);
    }

    private void initializeQueueForFullUpdate(Camera camera, ViewArea viewArea) {
        this.nodeQueue.clear();
        BlockPos pos = camera.getBlockPosition();
        SectionRenderDispatcher.RenderSection renderSection = viewArea.getRenderSectionAt(pos);
        if (renderSection != null) {
            this.nodeQueue.add(new Node(renderSection, 0));
            return;
        }
        Vec3 cameraPos = camera.getPosition();
        LevelHeightAccessor level = viewArea.getLevelHeightAccessor();
        boolean aboveVoid = pos.getY() > level.getMinBuildHeight();
        int startY = aboveVoid ? level.getMaxBuildHeight() - 8 : level.getMinBuildHeight() + 8;
        int startX = Mth.floor((double)(cameraPos.x / 16.0)) << 4;
        int startZ = Mth.floor((double)(cameraPos.z / 16.0)) << 4;
        int radius = this.viewDistance;
        ArrayList<Node> list = new ArrayList<Node>(4 * radius * radius);
        BlockPos.MutableBlockPos renderSectionPos = new BlockPos.MutableBlockPos();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                SectionRenderDispatcher.RenderSection section = viewArea.getRenderSectionAt((BlockPos)renderSectionPos.set(startX + x << 12, startY, startZ + z << 12));
                if (section == null || !this.isInViewDistance(pos, section.getOrigin())) continue;
                Direction direction = aboveVoid ? Direction.DOWN : Direction.UP;
                Node node2 = new Node(section, 0);
                node2.addSourceDirection(direction);
                node2.addDirection(direction);
                if (x > 0) {
                    node2.addDirection(Direction.EAST);
                } else if (x < 0) {
                    node2.addDirection(Direction.WEST);
                }
                if (z > 0) {
                    node2.addDirection(Direction.SOUTH);
                } else if (z < 0) {
                    node2.addDirection(Direction.NORTH);
                }
                list.add(node2);
            }
        }
        list.sort(Comparator.comparingDouble(node -> {
            BlockPos origin = node.section.getOrigin();
            return pos.distToCenterSqr((double)origin.getX() + 8.5, (double)origin.getY() + 8.5, (double)origin.getZ() + 8.5);
        }));
        this.nodeQueue.addAll((Collection<? extends Node>)list);
    }

    private void runUpdates(GraphStorage graphStorage, ViewArea viewArea, Vec3 cameraPosition, Frustum frustum, Queue<Node> nodeQueue, boolean smartCull, List<SectionRenderDispatcher.RenderSection> sections) {
        BlockPos cameraSectionPos = new BlockPos(Mth.floor((double)(cameraPosition.x / 16.0)) << 4, Mth.floor((double)(cameraPosition.y / 16.0)) << 4, Mth.floor((double)(cameraPosition.z / 16.0)) << 4);
        BlockPos cameraCenter = cameraSectionPos.offset(8, 8, 8);
        BlockPos.MutableBlockPos temp = new BlockPos.MutableBlockPos();
        LevelHeightAccessor level = viewArea.getLevelHeightAccessor();
        int maxBuildHeight = level.getMaxBuildHeight();
        int minBuildHeight = level.getMinBuildHeight();
        while (!nodeQueue.isEmpty()) {
            BlockPos origin;
            Node node = nodeQueue.poll();
            SectionRenderDispatcher.RenderSection renderSection = node.section;
            if (frustum.isVisible(renderSection.getBoundingBox()) && graphStorage.renderSections.add(renderSection.index)) {
                sections.add(node.section);
            }
            boolean far = Math.abs((origin = renderSection.getOrigin()).getX() - cameraSectionPos.getX()) > 60 || Math.abs(origin.getY() - cameraSectionPos.getY()) > 60 || Math.abs(origin.getZ() - cameraSectionPos.getZ()) > 60;
            for (Direction direction : DIRECTIONS) {
                Node node2;
                SectionRenderDispatcher.RenderSection section = this.getRelativeFrom(cameraSectionPos, renderSection, direction);
                if (section == null) continue;
                Direction opposite = direction.getOpposite();
                if (smartCull && (node.directions & 1 << opposite.ordinal()) != 0) continue;
                if (smartCull && node.sourceDirections != 0) {
                    SectionRenderDispatcher.CompiledSection compiledSection = renderSection.getCompiled();
                    boolean visible = false;
                    for (int i = 0; i < DIRECTIONS.length; ++i) {
                        if ((node.sourceDirections & 1 << i) == 0 || !compiledSection.facesCanSeeEachother(DIRECTIONS[i], opposite)) continue;
                        visible = true;
                        break;
                    }
                    if (!visible) continue;
                }
                BlockPos neighborOrigin = section.getOrigin();
                if (smartCull && far) {
                    int offsetY;
                    int offsetX;
                    int n = (direction.getAxis() == Direction.Axis.X ? cameraCenter.getX() <= neighborOrigin.getX() : cameraCenter.getX() >= neighborOrigin.getX()) ? 0 : (offsetX = 16);
                    int n2 = (direction.getAxis() == Direction.Axis.Y ? cameraCenter.getY() <= neighborOrigin.getY() : cameraCenter.getY() >= neighborOrigin.getY()) ? 0 : (offsetY = 16);
                    int offsetZ = (direction.getAxis() == Direction.Axis.Z ? cameraCenter.getZ() <= neighborOrigin.getZ() : cameraCenter.getZ() >= neighborOrigin.getZ()) ? 0 : 16;
                    temp.setWithOffset((Vec3i)neighborOrigin, offsetX, offsetY, offsetZ);
                    Vector3d pos = new Vector3d(cameraPosition.x - (double)temp.getX(), cameraPosition.y - (double)temp.getY(), cameraPosition.z - (double)temp.getZ());
                    Vector3d step = pos.normalize(CEILED_SECTION_DIAGONAL, new Vector3d());
                    boolean visible = true;
                    while (pos.distanceSquared(cameraPosition.x, cameraPosition.y, cameraPosition.z) > 3600.0) {
                        pos.add((Vector3dc)step);
                        if (pos.y > (double)maxBuildHeight || pos.y < (double)minBuildHeight) break;
                        SectionRenderDispatcher.RenderSection renderSection3 = viewArea.getRenderSectionAt((BlockPos)temp.set(Math.floor(pos.x), Math.floor(pos.y), Math.floor(pos.z)));
                        if (renderSection3 != null && graphStorage.sectionToNodeMap.get(renderSection3) != null) continue;
                        visible = false;
                        break;
                    }
                    if (!visible) continue;
                }
                if ((node2 = graphStorage.sectionToNodeMap.get(section)) != null) {
                    node2.addSourceDirection(direction);
                    continue;
                }
                Node node3 = new Node(section, node.step + 1);
                node3.addSourceDirection(direction);
                node3.addDirection(direction);
                if (section.hasAllNeighbors()) {
                    nodeQueue.add(node3);
                    graphStorage.sectionToNodeMap.put(section, node3);
                    continue;
                }
                if (!this.isInViewDistance(cameraSectionPos, neighborOrigin)) continue;
                graphStorage.sectionToNodeMap.put(section, node3);
            }
        }
    }

    private boolean isInViewDistance(BlockPos pos, BlockPos origin) {
        int centerX = pos.getX() >> 4;
        int centerZ = pos.getZ() >> 4;
        int x = origin.getX() >> 4;
        int z = origin.getZ() >> 4;
        return ChunkTrackingView.isWithinDistance((int)centerX, (int)centerZ, (int)this.viewDistance, (int)x, (int)z, (boolean)false);
    }

    @Nullable
    private SectionRenderDispatcher.RenderSection getRelativeFrom(BlockPos pos, SectionRenderDispatcher.RenderSection section, Direction direction) {
        BlockPos origin = section.getRelativeOrigin(direction);
        if (!this.isInViewDistance(pos, origin)) {
            return null;
        }
        return Mth.abs((int)(pos.getY() - origin.getY())) > this.viewDistance << 4 ? null : this.viewArea.getRenderSectionAt(origin);
    }

    private static class NodeQueue
    implements Queue<Node> {
        private Node[] data;
        private int size;
        private int readPointer;

        public NodeQueue(int initialCapacity) {
            this.data = new Node[initialCapacity];
            this.size = 0;
        }

        public void trim(int size) {
            if (this.data.length > size) {
                this.data = new Node[size];
            }
            this.size = 0;
            this.readPointer = 0;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.readPointer >= this.size;
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Iterator<Node> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public <T> T[] toArray(@NotNull T[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Node node) {
            if (this.size >= this.data.length) {
                this.data = Arrays.copyOf(this.data, this.data.length * 2);
            }
            this.data[this.size++] = node;
            return true;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(@NotNull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends Node> c) {
            if (this.isEmpty() && c instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)c;
                this.data = (Node[])arrayList.toArray(Node[]::new);
                return true;
            }
            if (this.size + c.size() > this.data.length) {
                this.data = Arrays.copyOf(this.data, this.size + c.size());
            }
            for (Node node : c) {
                this.data[this.size++] = node;
            }
            return true;
        }

        @Override
        public boolean removeAll(@NotNull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(@NotNull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.size = 0;
            this.readPointer = 0;
        }

        @Override
        public boolean offer(Node node) {
            return this.add(node);
        }

        @Override
        public Node remove() {
            if (this.readPointer < this.size) {
                return this.data[this.readPointer++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public Node poll() {
            if (this.readPointer < this.size) {
                return this.data[this.readPointer++];
            }
            return null;
        }

        @Override
        public Node element() {
            if (this.readPointer < this.size) {
                return this.data[this.readPointer];
            }
            throw new NoSuchElementException();
        }

        @Override
        public Node peek() {
            return this.readPointer >= this.size ? null : this.data[this.readPointer];
        }

        @Override
        public void forEach(Consumer<? super Node> action) {
            for (int i = this.readPointer; i < this.size; ++i) {
                action.accept(this.data[i]);
            }
        }
    }

    private static class GraphStorage {
        public final SectionToNodeMap sectionToNodeMap;
        public final IntSet renderSections;

        public GraphStorage(int size) {
            this.sectionToNodeMap = new SectionToNodeMap(size);
            this.renderSections = new IntArraySet(size);
        }
    }

    private static class Node {
        private final SectionRenderDispatcher.RenderSection section;
        private int sourceDirections;
        private int directions;
        private final int step;

        private Node(SectionRenderDispatcher.RenderSection section, int step) {
            this.section = section;
            this.step = step;
        }

        private void addDirection(Direction direction) {
            this.directions |= 1 << direction.ordinal();
        }

        private void addSourceDirection(Direction sourceDirection) {
            this.sourceDirections |= 1 << sourceDirection.ordinal();
        }

        public int hashCode() {
            return this.section.getOrigin().hashCode();
        }

        public boolean equals(Object object) {
            return this.section.getOrigin().equals((Object)((Node)object).section.getOrigin());
        }
    }

    private static class SectionToNodeMap {
        private final Node[] nodes;

        private SectionToNodeMap(int size) {
            this.nodes = new Node[size];
        }

        public void put(SectionRenderDispatcher.RenderSection section, Node node) {
            this.nodes[section.index] = node;
        }

        @Nullable
        public Node get(SectionRenderDispatcher.RenderSection section) {
            int index = section.index;
            return index >= 0 && index < this.nodes.length ? this.nodes[index] : null;
        }
    }
}

