/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.post.uniform;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import foundry.veil.api.client.render.post.uniform.FloatUniform;
import foundry.veil.api.client.render.post.uniform.IntUniform;
import foundry.veil.api.client.render.post.uniform.Matrix2Uniform;
import foundry.veil.api.client.render.post.uniform.Matrix3Uniform;
import foundry.veil.api.client.render.post.uniform.Matrix4Uniform;
import foundry.veil.api.client.render.shader.uniform.ShaderUniform;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;

public sealed interface UniformValue
permits FloatUniform, IntUniform, Matrix2Uniform, Matrix3Uniform, Matrix4Uniform {
    public static final Codec<UniformValue> CODEC = Type.CODEC.dispatch(UniformValue::type, Type::getCodec);

    public void apply(ShaderUniform var1);

    public Type type();

    public static enum Type {
        FLOAT(FloatUniform.CODEC),
        INT(IntUniform.CODEC),
        MAT2(Matrix2Uniform.CODEC),
        MAT3(Matrix3Uniform.CODEC),
        MAT4(Matrix4Uniform.CODEC);

        private static final Type[] VALUES;
        private static final String VALID_OPTIONS;
        public static final Codec<Type> CODEC;
        private final MapCodec<? extends UniformValue> codec;

        private Type(MapCodec<? extends UniformValue> codec) {
            this.codec = codec;
        }

        public MapCodec<? extends UniformValue> getCodec() {
            return this.codec;
        }

        static {
            VALUES = Type.values();
            VALID_OPTIONS = Arrays.stream(VALUES).map(type -> type.name().toLowerCase(Locale.ROOT)).collect(Collectors.joining(", "));
            CODEC = Codec.STRING.flatXmap(name -> {
                for (Type type : VALUES) {
                    if (!type.name().equalsIgnoreCase((String)name)) continue;
                    return DataResult.success((Object)((Object)type));
                }
                return DataResult.error(() -> "Unknown uniform type: " + name + ". Valid types: " + VALID_OPTIONS);
            }, type -> DataResult.success((Object)type.name().toLowerCase(Locale.ROOT)));
        }
    }
}

