/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.resource;

import com.mojang.serialization.Lifecycle;
import foundry.veil.mixin.registry.accessor.RegistryDataAccessor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class VeilDynamicRegistry {
    private static final ThreadLocal<Boolean> LOADING = ThreadLocal.withInitial(() -> false);

    public static CompletableFuture<Data> loadRegistries(ResourceManager resourceManager, Collection<RegistryDataLoader.RegistryData<?>> registries, Executor executor) {
        ConcurrentHashMap errors = new ConcurrentHashMap();
        List<RegistryDataLoader.Loader> loaders = registries.stream().map(data -> ((RegistryDataAccessor)data).invokeCreate(Lifecycle.stable(), errors)).toList();
        RegistryOps.RegistryInfoLookup ctx = RegistryDataLoader.createContext((RegistryAccess)RegistryAccess.EMPTY, loaders);
        return Util.sequence(loaders.stream().map(loader -> CompletableFuture.supplyAsync(() -> {
            LOADING.set(true);
            loader.loadFromResources(resourceManager, ctx);
            LOADING.set(false);
            WritableRegistry registry = loader.registry();
            try {
                registry.freeze();
            }
            catch (Exception e) {
                errors.put(registry.key(), e);
            }
            if (loader.data().requiredNonEmpty() && registry.size() == 0) {
                errors.put(registry.key(), new IllegalStateException("Registry must be non-empty"));
            }
            return registry;
        }, executor)).toList()).thenApply(list -> new Data((RegistryAccess)new RegistryAccess.ImmutableRegistryAccess(list).freeze(), Collections.unmodifiableMap(errors)));
    }

    @Nullable
    public static String printErrors(Map<ResourceKey<?>, Exception> errors) {
        if (errors.isEmpty()) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Map<ResourceLocation, Map<ResourceLocation, Exception>> sortedErrors = errors.entrySet().stream().collect(Collectors.groupingBy(entry -> ((ResourceKey)entry.getKey()).registry(), Collectors.toMap(entry -> ((ResourceKey)entry.getKey()).location(), Map.Entry::getValue)));
        sortedErrors.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(registryError -> {
            printWriter.printf("%n> %d Errors in registry %s:", ((Map)registryError.getValue()).size(), registryError.getKey());
            ((Map)registryError.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(elementError -> {
                Throwable error = (Throwable)elementError.getValue();
                while (error.getCause() != null) {
                    error = error.getCause();
                }
                printWriter.printf("%n>> Error in element %s: %s", elementError.getKey(), error.getMessage());
            });
        });
        printWriter.flush();
        return stringWriter.toString();
    }

    @ApiStatus.Internal
    public static boolean isLoading() {
        return LOADING.get();
    }

    public record Data(RegistryAccess registryAccess, Map<ResourceKey<?>, Exception> errors) {
    }
}

