/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.program;

import com.google.common.collect.Iterables;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import foundry.veil.api.client.render.shader.ShaderPreDefinitions;
import foundry.veil.api.client.render.shader.program.ShaderBlendMode;
import foundry.veil.api.client.render.shader.texture.ShaderTextureSource;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.Nullable;

public record ProgramDefinition(@Nullable ResourceLocation vertex, @Nullable ResourceLocation tesselationControl, @Nullable ResourceLocation tesselationEvaluation, @Nullable ResourceLocation geometry, @Nullable ResourceLocation fragment, @Nullable ResourceLocation compute, String[] definitions, Map<String, String> definitionDefaults, Map<String, ShaderTextureSource> textures, Int2ObjectMap<ResourceLocation> shaders, @Nullable ShaderBlendMode blendMode) {
    public Map<String, String> getMacros(Set<String> dependencies, ShaderPreDefinitions definitions) {
        HashMap<String, String> macros = new HashMap<String, String>(definitions.getStaticDefinitions());
        for (String name : this.definitions) {
            String definition = definitions.getDefinition(name);
            if (definition != null) {
                macros.put(name.toUpperCase(Locale.ROOT), definition);
            } else {
                String definitionDefault = this.definitionDefaults.get(name);
                if (definitionDefault != null) {
                    macros.put(name.toUpperCase(Locale.ROOT), definitionDefault);
                }
            }
            dependencies.add(name);
        }
        return macros;
    }

    public static class Deserializer
    implements JsonDeserializer<ProgramDefinition> {
        @Nullable
        private static ResourceLocation deserializeSource(JsonObject json, String name, JsonDeserializationContext context) {
            JsonElement element = json.get(name);
            if (element == null) {
                return null;
            }
            return (ResourceLocation)context.deserialize(element, ResourceLocation.class);
        }

        private String[] deserializeDefinitions(JsonArray json, Map<String, String> defaults) throws JsonParseException {
            ArrayList<String> definitions = new ArrayList<String>(json.size());
            for (int i = 0; i < json.size(); ++i) {
                JsonElement element = json.get(i);
                if (element.isJsonPrimitive()) {
                    definitions.add(element.getAsJsonPrimitive().getAsString());
                    continue;
                }
                if (element.isJsonObject()) {
                    JsonObject definitionJson = element.getAsJsonObject();
                    Set entrySet = definitionJson.entrySet();
                    if (entrySet.size() != 1) {
                        throw new JsonSyntaxException("Expected definitions[" + i + "] to have one element, had " + entrySet.size());
                    }
                    Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)entrySet);
                    definitions.add((String)entry.getKey());
                    defaults.put((String)entry.getKey(), GsonHelper.convertToString((JsonElement)((JsonElement)entry.getValue()), (String)("definitions[" + i + "]")));
                    continue;
                }
                throw new JsonSyntaxException("Expected definitions[" + i + "] to be a JsonPrimitive or Object, was " + GsonHelper.getType((JsonElement)element));
            }
            return (String[])definitions.toArray(String[]::new);
        }

        private Map<String, ShaderTextureSource> deserializeTextures(JsonObject json) throws JsonParseException {
            HashMap<String, ShaderTextureSource> textures = new HashMap<String, ShaderTextureSource>();
            for (Map.Entry entry : json.entrySet()) {
                String name = (String)entry.getKey();
                DataResult texture = ShaderTextureSource.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)entry.getValue()));
                if (texture.error().isPresent()) {
                    throw new JsonSyntaxException("Failed to deserialize texture: " + name + ". " + ((DataResult.Error)texture.error().get()).message());
                }
                textures.put(name, (ShaderTextureSource)texture.result().orElseThrow());
            }
            ShaderTextureSource.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
            return Collections.unmodifiableMap(textures);
        }

        public ProgramDefinition deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            ShaderBlendMode blendMode;
            Map<String, ShaderTextureSource> textures;
            Map<String, String> definitionDefaults;
            String[] definitions;
            JsonObject json = element.getAsJsonObject();
            ResourceLocation vertex = Deserializer.deserializeSource(json, "vertex", context);
            ResourceLocation tesselationControl = Deserializer.deserializeSource(json, "tesselation_control", context);
            ResourceLocation tesselationEvaluation = Deserializer.deserializeSource(json, "tesselation_evaluation", context);
            ResourceLocation geometry = Deserializer.deserializeSource(json, "geometry", context);
            ResourceLocation fragment = Deserializer.deserializeSource(json, "fragment", context);
            ResourceLocation compute = Deserializer.deserializeSource(json, "compute", context);
            if (json.has("definitions")) {
                HashMap<String, String> defaults = new HashMap<String, String>();
                definitions = this.deserializeDefinitions(json.getAsJsonArray("definitions"), defaults);
                definitionDefaults = Collections.unmodifiableMap(defaults);
            } else {
                definitions = new String[]{};
                definitionDefaults = Collections.emptyMap();
            }
            Map<String, ShaderTextureSource> map = textures = json.has("textures") ? this.deserializeTextures(json.getAsJsonObject("textures")) : Collections.emptyMap();
            if (json.has("blend")) {
                DataResult result = ShaderBlendMode.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json.get("blend"));
                if (result.isError()) {
                    throw new JsonSyntaxException(((DataResult.Error)result.error().orElseThrow()).message());
                }
                blendMode = (ShaderBlendMode)result.result().orElseThrow();
            } else {
                blendMode = null;
            }
            Int2ObjectArrayMap sources = new Int2ObjectArrayMap();
            if (vertex != null) {
                sources.put(35633, (Object)vertex);
            }
            if (tesselationControl != null) {
                sources.put(36488, (Object)tesselationControl);
            }
            if (tesselationEvaluation != null) {
                sources.put(36487, (Object)tesselationEvaluation);
            }
            if (geometry != null) {
                sources.put(36313, (Object)geometry);
            }
            if (fragment != null) {
                sources.put(35632, (Object)fragment);
            }
            if (compute != null) {
                sources.put(37305, (Object)compute);
            }
            return new ProgramDefinition(vertex, tesselationControl, tesselationEvaluation, geometry, fragment, compute, definitions, definitionDefaults, textures, (Int2ObjectMap<ResourceLocation>)Int2ObjectMaps.unmodifiable((Int2ObjectMap)sources), blendMode);
        }
    }
}

