/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.vertex;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.vertex.VertexArray;
import foundry.veil.api.client.render.vertex.VertexArrayBuilder;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.ARBVertexAttrib64Bit;
import org.lwjgl.opengl.GL33C;

@ApiStatus.Internal
public class LegacyVertexAttribBindingBuilder
implements VertexArrayBuilder {
    private final VertexArray vertexArray;
    private final VertexBufferRegion[] vertexBuffers;
    private int boundIndex = -1;

    public LegacyVertexAttribBindingBuilder(VertexArray vertexArray) {
        this.vertexArray = vertexArray;
        this.vertexBuffers = new VertexBufferRegion[VeilRenderSystem.maxVertexAttributes()];
    }

    private void bindIndex(int index) {
        if (index < 0 || index >= this.vertexBuffers.length) {
            throw new IllegalArgumentException("Invalid vertex attribute index. Must be between 0 and " + (this.vertexBuffers.length - 1) + ": " + index);
        }
        if (this.boundIndex != index) {
            if (this.vertexBuffers[index] == null) {
                throw new IllegalArgumentException("No vertex buffer defined for index: " + index);
            }
            RenderSystem.glBindBuffer((int)34962, (int)this.vertexBuffers[index].buffer);
            this.boundIndex = index;
        }
    }

    @Override
    public VertexArray vertexArray() {
        return this.vertexArray;
    }

    @Override
    public VertexArrayBuilder defineVertexBuffer(int index, int buffer, int offset, int stride, int divisor) {
        if (index < 0 || index >= this.vertexBuffers.length) {
            throw new IllegalArgumentException("Invalid vertex attribute index. Must be between 0 and " + (this.vertexBuffers.length - 1) + ": " + index);
        }
        this.vertexBuffers[index] = new VertexBufferRegion(buffer, offset, stride, divisor);
        return this;
    }

    @Override
    public VertexArrayBuilder setVertexAttribute(int index, int bufferIndex, int size, VertexArrayBuilder.DataType type, boolean normalized, int relativeOffset) {
        VertexArrayBuilder.validateRelativeOffset(relativeOffset);
        this.bindIndex(bufferIndex);
        GL33C.glEnableVertexAttribArray((int)index);
        GL33C.glVertexAttribPointer((int)index, (int)size, (int)type.getGlType(), (boolean)normalized, (int)this.vertexBuffers[this.boundIndex].stride, (long)(this.vertexBuffers[this.boundIndex].offset + relativeOffset));
        GL33C.glVertexAttribDivisor((int)index, (int)this.vertexBuffers[this.boundIndex].divisor);
        return this;
    }

    @Override
    public VertexArrayBuilder setVertexIAttribute(int index, int bufferIndex, int size, VertexArrayBuilder.DataType type, int relativeOffset) {
        VertexArrayBuilder.validateRelativeOffset(relativeOffset);
        this.bindIndex(bufferIndex);
        GL33C.glEnableVertexAttribArray((int)index);
        GL33C.glVertexAttribIPointer((int)index, (int)size, (int)type.getGlType(), (int)this.vertexBuffers[this.boundIndex].stride, (long)(this.vertexBuffers[this.boundIndex].offset + relativeOffset));
        GL33C.glVertexAttribDivisor((int)index, (int)this.vertexBuffers[this.boundIndex].divisor);
        return this;
    }

    @Override
    public VertexArrayBuilder setVertexLAttribute(int index, int bufferIndex, int size, VertexArrayBuilder.DataType type, int relativeOffset) {
        if (!VeilRenderSystem.vertexAttribute64BitSupported()) {
            throw new UnsupportedOperationException("Long attributes not supported");
        }
        this.bindIndex(bufferIndex);
        GL33C.glEnableVertexAttribArray((int)index);
        ARBVertexAttrib64Bit.glVertexAttribLPointer((int)index, (int)size, (int)type.getGlType(), (int)this.vertexBuffers[this.boundIndex].stride, (long)(this.vertexBuffers[this.boundIndex].offset + relativeOffset));
        GL33C.glVertexAttribDivisor((int)index, (int)this.vertexBuffers[this.boundIndex].divisor);
        return this;
    }

    @Override
    public VertexArrayBuilder removeVertexBuffer(int index) {
        if (index < 0 || index >= this.vertexBuffers.length) {
            throw new IllegalArgumentException("Invalid vertex attribute index. Must be between 0 and " + (this.vertexBuffers.length - 1) + ": " + index);
        }
        this.vertexBuffers[index] = null;
        return this;
    }

    @Override
    public VertexArrayBuilder removeAttribute(int index) {
        GL33C.glDisableVertexAttribArray((int)index);
        return this;
    }

    @Override
    public VertexArrayBuilder clearVertexBuffers() {
        Arrays.fill(this.vertexBuffers, null);
        return this;
    }

    @Override
    public VertexArrayBuilder clearVertexAttributes() {
        for (int i = 0; i < VeilRenderSystem.maxVertexAttributes(); ++i) {
            GL33C.glDisableVertexAttribArray((int)i);
        }
        return this;
    }

    private record VertexBufferRegion(int buffer, int offset, int stride, int divisor) {
    }
}

