/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.wrapper;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.AdvancedFboAttachment;
import foundry.veil.api.client.render.framebuffer.AdvancedFboTextureAttachment;
import foundry.veil.api.client.render.texture.TextureFilter;
import foundry.veil.mixin.framebuffer.accessor.FramebufferRenderTargetAccessor;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL30C;

@ApiStatus.Internal
public abstract class VanillaAdvancedFboWrapper
implements AdvancedFbo {
    private final Supplier<RenderTarget> renderTargetSupplier;
    private final Supplier<AttachmentWrapper> colorBuffer;
    private final Supplier<AttachmentWrapper> depthBuffer;
    private final int[] drawBuffers;
    private boolean hasStencil;
    private int depthTextureCache;

    public VanillaAdvancedFboWrapper(Supplier<RenderTarget> renderTargetSupplier) {
        this.renderTargetSupplier = renderTargetSupplier;
        this.colorBuffer = Suppliers.memoize(() -> new AttachmentWrapper(this, () -> this.toRenderTarget().getColorTextureId(), 36064));
        this.depthBuffer = Suppliers.memoize(() -> new AttachmentWrapper(this, () -> this.toRenderTarget().getDepthTextureId(), 36096));
        this.drawBuffers = new int[]{36064};
        this.hasStencil = false;
        this.depthTextureCache = 0;
    }

    @Override
    public void create() {
        throw new UnsupportedOperationException("Vanilla framebuffers cannot be created");
    }

    @Override
    public void clear() {
        float[] clearChannels = ((FramebufferRenderTargetAccessor)this.toRenderTarget()).getClearChannels();
        this.clear(clearChannels[0], clearChannels[1], clearChannels[2], clearChannels[3], this.getClearMask(), this.getDrawBuffers());
    }

    @Override
    public void clear(int buffers) {
        float[] clearChannels = ((FramebufferRenderTargetAccessor)this.toRenderTarget()).getClearChannels();
        this.clear(clearChannels[0], clearChannels[1], clearChannels[2], clearChannels[3], buffers, this.getDrawBuffers());
    }

    @Override
    public void resetDrawBuffers() {
    }

    @Override
    public void drawBuffers(int ... buffers) {
    }

    @Override
    public void bind(boolean setViewport) {
        this.toRenderTarget().bindWrite(setViewport);
    }

    @Override
    public void bindDraw(boolean setViewport) {
        RenderTarget renderTarget = this.toRenderTarget();
        GlStateManager._glBindFramebuffer((int)36009, (int)renderTarget.frameBufferId);
        if (setViewport) {
            RenderSystem.viewport((int)0, (int)0, (int)renderTarget.viewWidth, (int)renderTarget.viewHeight);
        }
    }

    @Override
    public int getId() {
        return this.toRenderTarget().frameBufferId;
    }

    @Override
    public int getWidth() {
        return this.toRenderTarget().width;
    }

    @Override
    public int getHeight() {
        return this.toRenderTarget().height;
    }

    @Override
    public int getColorAttachments() {
        return 1;
    }

    @Override
    public int getClearMask() {
        return 0x4000 | (this.toRenderTarget().useDepth ? 256 : 0);
    }

    @Override
    public int[] getDrawBuffers() {
        return this.drawBuffers;
    }

    @Override
    public boolean hasColorAttachment(int attachment) {
        return attachment == 0;
    }

    @Override
    public boolean hasDepthAttachment() {
        return this.toRenderTarget().useDepth;
    }

    @Override
    public boolean hasStencilAttachment() {
        RenderTarget renderTarget = this.toRenderTarget();
        if (!renderTarget.useDepth) {
            return false;
        }
        int depthTextureId = renderTarget.getDepthTextureId();
        if (this.depthTextureCache == depthTextureId) {
            return this.hasStencil;
        }
        this.depthTextureCache = renderTarget.getDepthTextureId();
        GlStateManager._bindTexture((int)depthTextureId);
        int format = GL30C.glGetTexParameteri((int)3553, (int)4099);
        this.hasStencil = format == 34041 || format == 35056 || format == 36013;
        return this.hasStencil;
    }

    @Override
    public AdvancedFboAttachment getColorAttachment(int attachment) {
        Validate.isTrue((boolean)this.hasColorAttachment(attachment), (String)("Color attachment " + attachment + " does not exist."), (Object[])new Object[0]);
        return this.colorBuffer.get();
    }

    @Override
    public AdvancedFboAttachment getDepthAttachment() {
        Validate.isTrue((boolean)this.hasDepthAttachment(), (String)"Depth attachment does not exist.", (Object[])new Object[0]);
        return this.depthBuffer.get();
    }

    @Override
    @Nullable
    public String getDebugLabel() {
        return null;
    }

    @Override
    public RenderTarget toRenderTarget() {
        return this.renderTargetSupplier.get();
    }

    public void free() {
        this.toRenderTarget().destroyBuffers();
    }

    private static class AttachmentWrapper
    extends AdvancedFboTextureAttachment {
        private final AdvancedFbo parent;
        private final IntSupplier id;

        private AttachmentWrapper(AdvancedFbo parent, IntSupplier id, int type) {
            super(type, 0, 0, 0, 0, 0, 0, TextureFilter.CLAMP, null);
            this.parent = parent;
            this.id = id;
        }

        @Override
        public void create() {
            throw new UnsupportedOperationException("Vanilla framebuffer attachments cannot be created");
        }

        @Override
        public void attach(AdvancedFbo framebuffer, int attachment) {
            throw new UnsupportedOperationException("Vanilla framebuffer attachments cannot be attached");
        }

        public int getId() {
            return this.id.getAsInt();
        }

        @Override
        @NotNull
        public AdvancedFboTextureAttachment clone() {
            return new AttachmentWrapper(this.parent, this.id, this.getAttachmentType());
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AttachmentWrapper that = (AttachmentWrapper)o;
            return this.id.getAsInt() == that.id.getAsInt();
        }

        @Override
        public int hashCode() {
            return this.id.getAsInt();
        }

        @Override
        public void free() {
            throw new UnsupportedOperationException("Vanilla framebuffer attachments cannot be deleted");
        }
    }
}

