package foundry.veil.mixin.imgui.client;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import imgui.ImGui;
import net.minecraft.client.MouseHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(MouseHandler.class)
public class MouseHandlerMixin {

    @Inject(method = "onPress", at = @At("HEAD"), cancellable = true)
    public void mouseButtonCallback(long window, int button, int action, int mods, CallbackInfo ci) {
        Veil.withImGui(() -> {
            if (ImGui.getIO().getWantCaptureMouse()) {
                ci.cancel();
            }
        });
    }

    @Inject(method = "onScroll", at = @At("HEAD"), cancellable = true)
    public void scrollCallback(long window, double xOffset, double yOffset, CallbackInfo ci) {
        Veil.withImGui(() -> {
            if (ImGui.getIO().getWantCaptureMouse()) {
                ci.cancel();
            }
        });
    }

    @Inject(method = "grabMouse", at = @At("HEAD"))
    public void grabMouse(CallbackInfo ci) {
        Veil.withImGui(() -> ImGui.setWindowFocus(null));
    }

    // REI calls these on another thread for some reason, so it's possible other mods may do the same thing

    @Inject(method = "xpos", at = @At("HEAD"), cancellable = true)
    public void cancelMouseX(CallbackInfoReturnable<Double> cir) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            return;
        }

        Veil.withImGui(() -> {
            if (ImGui.getIO().getWantCaptureMouse()) {
                cir.setReturnValue(Double.MIN_VALUE);
            }
        });
    }

    @Inject(method = "ypos", at = @At("HEAD"), cancellable = true)
    public void cancelMouseY(CallbackInfoReturnable<Double> cir) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            return;
        }

        Veil.withImGui(() -> {
            if (ImGui.getIO().getWantCaptureMouse()) {
                cir.setReturnValue(Double.MIN_VALUE);
            }
        });
    }
}
