/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader.program;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.Program;
import com.mojang.blaze3d.shaders.Shader;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.ext.VeilDebug;
import foundry.veil.api.client.render.shader.ShaderSourceSet;
import foundry.veil.api.client.render.shader.block.ShaderBlock;
import foundry.veil.api.client.render.shader.compiler.CompiledShader;
import foundry.veil.api.client.render.shader.compiler.ShaderCompiler;
import foundry.veil.api.client.render.shader.compiler.ShaderException;
import foundry.veil.api.client.render.shader.compiler.VeilShaderSource;
import foundry.veil.api.client.render.shader.program.ProgramDefinition;
import foundry.veil.api.client.render.shader.program.ShaderBlendMode;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.client.render.shader.program.ShaderUniformCache;
import foundry.veil.api.client.render.shader.texture.ShaderTextureSource;
import foundry.veil.api.client.render.shader.uniform.ShaderUniform;
import foundry.veil.api.client.render.shader.uniform.ShaderUniformAccess;
import foundry.veil.api.client.render.texture.SamplerObject;
import foundry.veil.api.client.render.texture.TextureFilter;
import foundry.veil.api.client.util.VertexFormatCodec;
import foundry.veil.impl.client.render.shader.program.ShaderTextureCache;
import foundry.veil.impl.client.render.shader.uniform.ShaderUniformImpl;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.resources.Resource;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix2f;
import org.joml.Matrix2fc;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3f;
import org.joml.Matrix4x3fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.NativeResource;

@ApiStatus.Internal
public class ShaderProgramImpl
implements ShaderProgram {
    public static final VeilShaderSource DUMMY_FRAGMENT_SHADER = new VeilShaderSource(null, "out vec4 fragColor;void main(){fragColor=vec4(1.0);}");
    private static final Matrix4f MODEL_VIEW_MATRIX = new Matrix4f();
    private static final Matrix4f PROJECTION_MATRIX = new Matrix4f();
    private static boolean restoreEquation = false;
    private static int srcColorFactor = -1;
    private static int dstColorFactor = -1;
    private static int srcAlphaFactor = -1;
    private static int dstAlphaFactor = -1;
    private final ResourceLocation name;
    private final ShaderTextureCache textures;
    private final Int2ObjectMap<CompiledProgram> programs;
    private final Map<String, ShaderTexture> definitionTextures;
    private final Object2ObjectMap<CharSequence, ShaderBlock<?>> shaderBlocks;
    private final Map<String, ShaderUniformImpl> uniforms;
    private final Supplier<Wrapper> wrapper;
    private VertexFormat vertexFormat;
    private ProgramDefinition definition;
    private CompiledProgram compiledProgram;

    public ShaderProgramImpl(ResourceLocation name) {
        this.name = name;
        this.textures = new ShaderTextureCache(this);
        this.programs = new Int2ObjectArrayMap(1);
        this.definitionTextures = new Object2ObjectArrayMap();
        this.shaderBlocks = new Object2ObjectArrayMap();
        this.uniforms = new Object2ObjectArrayMap();
        this.wrapper = Suppliers.memoize(() -> {
            Wrapper.constructingProgram = this;
            try {
                Wrapper wrapper = new Wrapper(this);
                return wrapper;
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to wrap shader program: " + String.valueOf(name), e);
            }
            finally {
                Wrapper.constructingProgram = null;
            }
        });
    }

    public static void saveBlendState(boolean saveEquation) {
        restoreEquation = saveEquation;
        srcColorFactor = GlStateManager.BLEND.srcRgb;
        dstColorFactor = GlStateManager.BLEND.dstRgb;
        srcAlphaFactor = GlStateManager.BLEND.srcAlpha;
        dstAlphaFactor = GlStateManager.BLEND.dstAlpha;
    }

    public static void restoreBlendState() {
        if (srcColorFactor == -1) {
            return;
        }
        if (restoreEquation) {
            GL20C.glBlendEquationSeparate((int)32774, (int)32774);
        }
        GlStateManager._blendFuncSeparate((int)srcColorFactor, (int)dstColorFactor, (int)srcAlphaFactor, (int)dstAlphaFactor);
        srcColorFactor = -1;
        dstColorFactor = -1;
        srcAlphaFactor = -1;
        dstAlphaFactor = -1;
        restoreEquation = false;
    }

    protected void applyProgram(CompiledProgram program) throws ShaderException {
        program.link(this);
        this.textures.clear();
        this.compiledProgram = program;
        this.vertexFormat = program.detectVertexFormat();
        HashSet<ShaderUniformImpl> old = new HashSet<ShaderUniformImpl>(this.uniforms.values());
        for (Map.Entry<String, ShaderUniformCache.Uniform> entry : this.compiledProgram.uniformCache.getUniforms().entrySet()) {
            ShaderUniformCache.Uniform data = entry.getValue();
            if (data.type() == 37595) continue;
            ShaderUniformImpl uniform = this.getOrCreateShaderUniform(entry.getKey());
            old.remove(uniform);
            uniform.set(data);
        }
        for (ShaderUniformImpl uniform : old) {
            uniform.set(null);
        }
    }

    protected void attachShaders(CompiledProgram compiledProgram, ShaderSourceSet sourceSet, ShaderCompiler compiler) throws ShaderException, IOException {
        Int2ObjectMap<ResourceLocation> shaders = this.definition.shaders();
        for (Int2ObjectMap.Entry entry : shaders.int2ObjectEntrySet()) {
            int glType = entry.getIntKey();
            ResourceLocation source = (ResourceLocation)entry.getValue();
            compiledProgram.attachShader(glType, compiler.compile(glType, sourceSet.getTypeConverter(glType).idToFile(source)));
        }
        if (Minecraft.ON_OSX && !shaders.containsKey(37305) && !shaders.containsKey(35632)) {
            compiledProgram.attachShader(35632, compiler.compile(35632, DUMMY_FRAGMENT_SHADER));
        }
    }

    public void compile(int activeBuffers, ShaderSourceSet sourceSet, @Nullable ProgramDefinition definition, ShaderCompiler compiler) throws ShaderException, IOException {
        this.definition = definition;
        this.recompile(activeBuffers, sourceSet, compiler);
        this.definitionTextures.values().forEach(NativeResource::free);
        this.definitionTextures.clear();
        if (this.definition != null) {
            for (Map.Entry<String, ShaderTextureSource> entry : this.definition.textures().entrySet()) {
                this.definitionTextures.put(entry.getKey(), ShaderTexture.create(entry.getValue()));
            }
        }
    }

    public void recompile(int activeBuffers, ShaderSourceSet sourceSet, ShaderCompiler compiler) throws ShaderException, IOException {
        CompiledProgram compiledProgram = CompiledProgram.create(this.name);
        try {
            this.attachShaders(compiledProgram, sourceSet, compiler);
            CompiledProgram old = (CompiledProgram)this.programs.put(activeBuffers, (Object)compiledProgram);
            if (old != null) {
                old.free();
            }
            this.applyProgram(compiledProgram);
        }
        catch (Exception e) {
            if (this.compiledProgram == null) {
                this.freeInternal();
            } else {
                compiledProgram.free();
            }
            throw e;
        }
    }

    public boolean setActiveBuffers(int activeBuffers) throws ShaderException {
        CompiledProgram compiledProgram = (CompiledProgram)this.programs.get(activeBuffers);
        if (compiledProgram != null) {
            if (this.compiledProgram != compiledProgram) {
                this.applyProgram(compiledProgram);
            }
            return false;
        }
        return true;
    }

    @Override
    public void bind() {
        VeilRenderSystem.clearShaderBlocks();
        for (Object2ObjectMap.Entry entry : this.shaderBlocks.object2ObjectEntrySet()) {
            VeilRenderSystem.bind((CharSequence)entry.getKey(), (ShaderBlock)entry.getValue());
        }
        ShaderBlendMode blendMode = this.definition.blendMode();
        if (blendMode != null) {
            ShaderProgramImpl.saveBlendState(blendMode.hasEquation());
            blendMode.apply();
        }
        ShaderProgram.super.bind();
    }

    @Override
    public void setDefaultUniforms(VertexFormat.Mode mode, Matrix4fc modelViewMatrix, Matrix4fc projectionMatrix) {
        this.toShaderInstance().setDefaultUniforms(mode, MODEL_VIEW_MATRIX.set(modelViewMatrix), PROJECTION_MATRIX.set(projectionMatrix), Minecraft.getInstance().getWindow());
    }

    private void freeInternal() {
        this.textures.clear();
        for (CompiledProgram program : this.programs.values()) {
            program.free();
        }
        this.uniforms.values().forEach(ShaderUniformImpl::free);
        this.uniforms.clear();
        this.definitionTextures.values().forEach(NativeResource::free);
        this.definitionTextures.clear();
        this.vertexFormat = null;
        this.compiledProgram = null;
    }

    public void free() {
        this.freeInternal();
    }

    @Override
    public Int2ObjectMap<CompiledShader> getShaders() {
        return this.compiledProgram != null ? this.compiledProgram.shaders : Int2ObjectMaps.emptyMap();
    }

    @Override
    @Nullable
    public VertexFormat getFormat() {
        return this.vertexFormat;
    }

    @Override
    public Set<String> getDefinitionDependencies() {
        return this.compiledProgram != null ? this.compiledProgram.definitionDependencies : Collections.emptySet();
    }

    @Override
    public ResourceLocation getName() {
        return this.name;
    }

    @Override
    public Wrapper toShaderInstance() {
        return this.wrapper.get();
    }

    @Override
    public int getUniform(CharSequence name) {
        if (this.compiledProgram == null) {
            return -1;
        }
        ShaderUniformCache.Uniform uniform = this.compiledProgram.uniformCache.getUniform(name);
        return uniform != null ? uniform.location() : -1;
    }

    @Override
    @Nullable
    public ShaderUniformImpl getShaderUniform(CharSequence name) {
        ShaderUniformImpl uniform = this.uniforms.get(name.toString());
        return uniform != null && uniform.isValid() ? uniform : null;
    }

    @Override
    public ShaderUniformAccess getShaderUniformSafe(CharSequence name) {
        ShaderUniformImpl uniform = this.uniforms.get(name.toString());
        return uniform != null ? uniform : ShaderUniformAccess.EMPTY;
    }

    @Override
    public ShaderUniformImpl getOrCreateShaderUniform(CharSequence name) {
        return this.uniforms.computeIfAbsent(name.toString(), key -> new ShaderUniformImpl(this::getProgram, (String)key));
    }

    @Override
    public boolean hasUniform(CharSequence name) {
        return this.compiledProgram != null && this.compiledProgram.uniformCache.hasUniform(name.toString());
    }

    @Override
    public int getUniformBlock(CharSequence name) {
        if (this.compiledProgram == null) {
            return -1;
        }
        ShaderUniformCache.UniformBlock block = this.compiledProgram.uniformCache.getUniformBlock(name.toString());
        return block != null ? block.index() : -1;
    }

    @Override
    public boolean hasUniformBlock(CharSequence name) {
        return this.compiledProgram != null && this.compiledProgram.uniformCache.hasUniformBlock(name.toString());
    }

    @Override
    public int getStorageBlock(CharSequence name) {
        if (this.compiledProgram == null) {
            return -1;
        }
        ShaderUniformCache.StorageBlock block = this.compiledProgram.uniformCache.getStorageBlock(name.toString());
        return block != null ? block.index() : -1;
    }

    @Override
    public boolean hasStorageBlock(CharSequence name) {
        return this.compiledProgram != null && this.compiledProgram.uniformCache.hasStorageBlock(name.toString());
    }

    @Override
    public int getProgram() {
        return this.compiledProgram != null ? this.compiledProgram.program : 0;
    }

    @Override
    @Nullable
    public ProgramDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public void bindSamplers(@Nullable ShaderTextureSource.Context context, int samplerStart) {
        if (this.compiledProgram == null) {
            return;
        }
        if (context != null) {
            this.definitionTextures.forEach((name, source) -> this.setSampler((CharSequence)name, source.textureSource.getId(context), source.samplerId()));
        }
        this.textures.bind(this.compiledProgram.uniformCache, samplerStart);
    }

    @Override
    public void setSampler(CharSequence name, int textureId, int samplerId) {
        if (this.compiledProgram != null && this.compiledProgram.uniformCache.hasSampler(name.toString())) {
            this.textures.put(name, textureId, samplerId);
        }
    }

    @Override
    public void removeSampler(CharSequence name) {
        this.textures.remove(name);
    }

    @Override
    public void clearSamplers() {
        this.textures.clear();
    }

    public void addShaderBlock(String name, ShaderBlock<?> block) {
        this.shaderBlocks.put((Object)name, block);
    }

    public void clearShaderBlocks() {
        this.shaderBlocks.clear();
    }

    public record CompiledProgram(int program, Int2ObjectMap<CompiledShader> shaders, Int2ObjectMap<CompiledShader> shadersView, ShaderUniformCache uniformCache, Set<String> definitionDependencies) implements NativeResource
    {
        public static CompiledProgram create(ResourceLocation id) {
            int program = GL20C.glCreateProgram();
            VeilDebug.get().objectLabel(33506, program, "Shader Program " + String.valueOf(id));
            Int2ObjectArrayMap shaders = new Int2ObjectArrayMap(2);
            Int2ObjectMap shadersView = Int2ObjectMaps.unmodifiable((Int2ObjectMap)shaders);
            ShaderUniformCache uniforms = new ShaderUniformCache(() -> program);
            HashSet<String> definitionDependencies = new HashSet<String>();
            return new CompiledProgram(program, (Int2ObjectMap<CompiledShader>)shaders, (Int2ObjectMap<CompiledShader>)shadersView, uniforms, definitionDependencies);
        }

        public void attachShader(int glType, CompiledShader shader) {
            CompiledShader old = (CompiledShader)this.shaders.put(glType, (Object)shader);
            if (old != null) {
                old.free();
            }
            GL20C.glAttachShader((int)this.program, (int)shader.id());
        }

        @Nullable
        public VertexFormat detectVertexFormat() {
            VertexFormat best = null;
            int bestElements = 0;
            int activeAttributes = GL20C.glGetProgrami((int)this.program, (int)35721);
            Int2ObjectArrayMap names = new Int2ObjectArrayMap(activeAttributes);
            try (MemoryStack stack = MemoryStack.stackPush();){
                IntBuffer size = stack.mallocInt(1);
                IntBuffer type = stack.mallocInt(1);
                for (int i = 0; i < activeAttributes; ++i) {
                    String name = GL20C.glGetActiveAttrib((int)this.program, (int)i, (IntBuffer)size, (IntBuffer)type);
                    names.put(GL20C.glGetAttribLocation((int)this.program, (CharSequence)name), (Object)name);
                }
            }
            for (VertexFormat format : VertexFormatCodec.getDefaultFormats().values()) {
                List elements = format.getElements();
                int foundElements = 0;
                if (elements.size() > activeAttributes) continue;
                for (int i = 0; i < elements.size() && format.getElementName((VertexFormatElement)elements.get(i)).equals(names.get(i)); ++i) {
                    ++foundElements;
                }
                if (foundElements < elements.size() || bestElements > activeAttributes || foundElements <= bestElements) continue;
                best = format;
                bestElements = foundElements;
            }
            return best;
        }

        public void link(ShaderProgram shaderProgram) throws ShaderException {
            GL20C.glLinkProgram((int)this.program);
            if (GL20C.glGetProgrami((int)this.program, (int)35714) != 1) {
                String log = StringUtils.trim((String)GL20C.glGetProgramInfoLog((int)this.program));
                throw new ShaderException("Failed to link shader", log);
            }
            GL20C.glValidateProgram((int)this.program);
            if (GL20C.glGetProgrami((int)this.program, (int)35715) != 1) {
                String log = StringUtils.trim((String)GL20C.glGetProgramInfoLog((int)this.program));
                Veil.LOGGER.warn("Failed to validate shader ({}) : {}", (Object)shaderProgram.getName(), (Object)log);
            }
            this.uniformCache.clear();
            this.definitionDependencies.clear();
            this.shaders.values().forEach(shader -> {
                shader.apply(shaderProgram);
                this.definitionDependencies.addAll(shader.definitionDependencies());
            });
        }

        public void free() {
            for (CompiledShader shader : this.shaders.values()) {
                shader.free();
            }
            this.shaders.clear();
            GL20C.glDeleteProgram((int)this.program);
            this.uniformCache.clear();
            this.definitionDependencies.clear();
        }
    }

    public record ShaderTexture(ShaderTextureSource textureSource, @Nullable SamplerObject sampler) implements NativeResource
    {
        public static ShaderTexture create(ShaderTextureSource source) {
            SamplerObject samplerObject;
            TextureFilter filter = source.filter();
            if (filter != null) {
                samplerObject = SamplerObject.create();
                samplerObject.setFilter(filter);
            } else {
                samplerObject = null;
            }
            return new ShaderTexture(source, samplerObject);
        }

        public void free() {
            if (this.sampler != null) {
                this.sampler.free();
            }
        }

        public int samplerId() {
            return this.sampler != null ? this.sampler.getId() : 0;
        }
    }

    public static class Wrapper
    extends ShaderInstance {
        private static final Resource RESOURCE = new DummyShaderResource();
        private static final VertexFormat DUMMY_FORMAT = VertexFormat.builder().build();
        public static ShaderProgram constructingProgram = null;
        private final ShaderProgram program;

        private Wrapper(ShaderProgram program) throws IOException {
            super(name -> Optional.of(RESOURCE), "", DUMMY_FORMAT);
            this.program = program;
        }

        public void close() {
        }

        public void clear() {
            ShaderProgram.unbind();
        }

        public void apply() {
            this.program.bind();
            this.program.bindSamplers(0);
        }

        public void attachToProgram() {
            throw new UnsupportedOperationException("Cannot attach shader program wrapper");
        }

        public void markDirty() {
        }

        @Nullable
        public UniformWrapper getUniform(String name) {
            if (this.program != null && this.program.getUniform(name) == -1) {
                return null;
            }
            return (UniformWrapper)this.uniformMap.computeIfAbsent(name, unused -> new UniformWrapper(name, () -> Objects.requireNonNull(this.program).getOrCreateShaderUniform(name)));
        }

        public void setSampler(String name, Object value) {
            int sampler;
            Object object = value;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RenderTarget.class, AbstractTexture.class, Integer.class}, (Object)object2, n)) {
                case 0: {
                    RenderTarget target = (RenderTarget)object2;
                    int n2 = target.getColorTextureId();
                    break;
                }
                case 1: {
                    AbstractTexture texture = (AbstractTexture)object2;
                    int n2 = texture.getId();
                    break;
                }
                case 2: {
                    Integer id = (Integer)object2;
                    int n2 = id;
                    break;
                }
                default: {
                    int n2 = sampler = -1;
                }
            }
            if (sampler != -1) {
                if (sampler == 0) {
                    this.program.removeSampler(name);
                } else {
                    this.program.setSampler(name, sampler);
                }
            }
        }

        public VertexFormat getVertexFormat() {
            VertexFormat format = this.program.getFormat();
            return format != null ? format : super.getVertexFormat();
        }

        public ShaderProgram program() {
            return this.program;
        }
    }

    public static class ShaderWrapper
    extends Program {
        private final Program.Type type;
        private final ShaderProgram program;

        public ShaderWrapper(Program.Type type, ShaderProgram program) {
            super(type, 0, ShaderWrapper.getName(type, program));
            this.type = type;
            this.program = program;
        }

        private static String getName(Program.Type type, ShaderProgram program) {
            ProgramDefinition definition = program.getDefinition();
            if (definition != null) {
                switch (type) {
                    case VERTEX: {
                        ResourceLocation vertex = definition.vertex();
                        if (vertex == null) break;
                        return vertex.toString();
                    }
                    case FRAGMENT: {
                        ResourceLocation fragment = definition.fragment();
                        if (fragment == null) break;
                        return fragment.toString();
                    }
                }
            }
            return "veil:dummy_" + type.getName();
        }

        public void attachToShader(Shader shader) {
        }

        public void close() {
        }

        public String getName() {
            return ShaderWrapper.getName(this.type, this.program);
        }

        public int getId() {
            Int2ObjectMap<CompiledShader> shaders = this.program.getShaders();
            switch (this.type) {
                case VERTEX: {
                    CompiledShader vertex = (CompiledShader)shaders.get(35633);
                    return vertex != null ? vertex.id() : 0;
                }
                case FRAGMENT: {
                    CompiledShader fragment = (CompiledShader)shaders.get(35632);
                    return fragment != null ? fragment.id() : 0;
                }
            }
            return super.getId();
        }
    }

    public static class UniformWrapper
    extends Uniform {
        private static final Matrix2f MAT2X2 = new Matrix2f();
        private static final Matrix3f MAT3X3 = new Matrix3f();
        private static final Matrix3x2f MAT3X2 = new Matrix3x2f();
        private static final Matrix4x3f MAT4X3 = new Matrix4x3f();
        private static final Matrix4f MAT4X4 = new Matrix4f();
        private final Supplier<ShaderUniform> uniform;

        public UniformWrapper(String name, Supplier<ShaderUniform> uniform) {
            super(name, 0, 0, null);
            super.close();
            this.uniform = Suppliers.memoize(uniform::get);
        }

        public void setLocation(int location) {
        }

        public void set(int index, float value) {
            throw new UnsupportedOperationException("Use absolute set");
        }

        public void set(float value) {
            this.uniform.get().setFloat(value);
        }

        public void set(float x, float y) {
            this.uniform.get().setVector(x, y);
        }

        public void set(float x, float y, float z) {
            this.uniform.get().setVector(x, y, z);
        }

        public void set(float x, float y, float z, float w) {
            this.uniform.get().setVector(x, y, z, w);
        }

        public void set(@NotNull Vector3f value) {
            this.uniform.get().setVector((Vector3fc)value);
        }

        public void set(@NotNull Vector4f value) {
            this.uniform.get().setVector((Vector4fc)value);
        }

        public void setSafe(float x, float y, float z, float w) {
            this.set(x, y, z, w);
        }

        public void set(int value) {
            this.uniform.get().setInt(value);
        }

        public void set(int x, int y) {
            this.uniform.get().setVectorI(x, y);
        }

        public void set(int x, int y, int z) {
            this.uniform.get().setVectorI(x, y, z);
        }

        public void set(int x, int y, int z, int w) {
            this.uniform.get().setVectorI(x, y, z, w);
        }

        public void setSafe(int x, int y, int z, int w) {
            this.set(x, y, z, w);
        }

        public void set(float[] values) {
            this.uniform.get().setVector(values);
        }

        public void setMat2x2(float m00, float m01, float m10, float m11) {
            this.uniform.get().setMatrix((Matrix2fc)MAT2X2.set(m00, m01, m10, m11), false);
        }

        public void setMat2x3(float m00, float m01, float m02, float m10, float m11, float m12) {
            this.uniform.get().setMatrix((Matrix3x2fc)MAT3X2.set(m00, m10, m01, m11, m02, m12), true);
        }

        public void setMat2x4(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13) {
            throw new UnsupportedOperationException();
        }

        public void setMat3x2(float m00, float m01, float m10, float m11, float m20, float m21) {
            this.uniform.get().setMatrix((Matrix3x2fc)MAT3X2.set(m00, m01, m10, m11, m20, m21), false);
        }

        public void setMat3x3(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
            this.uniform.get().setMatrix((Matrix3fc)MAT3X3.set(m00, m01, m02, m10, m11, m12, m20, m21, m22), false);
        }

        public void setMat3x4(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23) {
            this.uniform.get().setMatrix((Matrix4x3fc)MAT4X3.set(m00, m10, m20, m01, m11, m21, m02, m12, m22, m03, m13, m23), true);
        }

        public void setMat4x3(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23) {
            this.uniform.get().setMatrix((Matrix4x3fc)MAT4X3.set(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23), false);
        }

        public void setMat4x2(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13) {
            throw new UnsupportedOperationException();
        }

        public void setMat4x4(float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
            this.uniform.get().setMatrix((Matrix4fc)MAT4X4.set(m00, m01, m02, m03, m10, m11, m12, m13, m20, m21, m22, m23, m30, m31, m32, m33), false);
        }

        public void set(@NotNull Matrix3f value) {
            this.uniform.get().setMatrix((Matrix3fc)value, false);
        }

        public void set(@NotNull Matrix4f value) {
            this.uniform.get().setMatrix((Matrix4fc)value, false);
        }

        public void upload() {
        }

        public void close() {
        }

        public int getLocation() {
            return this.uniform.get().getLocation();
        }
    }

    private static class DummyShaderResource
    extends Resource {
        private static final byte[] DUMMY_SHADER = "{\n    \"vertex\": \"dummy\",\n    \"fragment\": \"dummy\"\n}\n".getBytes(StandardCharsets.UTF_8);

        public DummyShaderResource() {
            super(null, () -> new ByteArrayInputStream(DUMMY_SHADER));
        }

        public PackResources source() {
            throw new UnsupportedOperationException("No pack source");
        }

        public String sourcePackId() {
            return "dummy";
        }

        public Optional<KnownPack> knownPackInfo() {
            return Optional.empty();
        }
    }
}

