/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.vertex;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.vertex.VertexArray;
import java.util.List;

public interface VertexArrayBuilder {
    public static void validateRelativeOffset(int offset) {
        if (offset < 0 || offset > VeilRenderSystem.maxVertexAttributeRelativeOffset()) {
            throw new IllegalArgumentException("Vertex array attribute relative offset must be between 0 and " + VeilRenderSystem.maxVertexAttributeRelativeOffset() + ". Was " + offset);
        }
    }

    public VertexArray vertexArray();

    default public VertexArrayBuilder applyFrom(int bufferIndex, int buffer, int attributeStart, VertexFormat format) {
        this.defineVertexBuffer(bufferIndex, buffer, 0, format.getVertexSize(), 0);
        List elements = format.getElements();
        for (int i = 0; i < elements.size(); ++i) {
            VertexFormatElement element = (VertexFormatElement)elements.get(i);
            VertexFormatElement.Usage usage = element.usage();
            if (usage == VertexFormatElement.Usage.UV && element.type() != VertexFormatElement.Type.FLOAT) {
                this.setVertexIAttribute(attributeStart + i, bufferIndex, element.count(), DataType.fromType(element.type()), format.getOffset(element));
                continue;
            }
            this.setVertexAttribute(attributeStart + i, bufferIndex, element.count(), DataType.fromType(element.type()), usage == VertexFormatElement.Usage.NORMAL || usage == VertexFormatElement.Usage.COLOR, format.getOffset(element));
        }
        return this;
    }

    public VertexArrayBuilder defineVertexBuffer(int var1, int var2, int var3, int var4, int var5);

    public VertexArrayBuilder setVertexAttribute(int var1, int var2, int var3, DataType var4, boolean var5, int var6);

    public VertexArrayBuilder setVertexIAttribute(int var1, int var2, int var3, DataType var4, int var5);

    public VertexArrayBuilder setVertexLAttribute(int var1, int var2, int var3, DataType var4, int var5);

    public VertexArrayBuilder removeVertexBuffer(int var1);

    public VertexArrayBuilder removeAttribute(int var1);

    public VertexArrayBuilder clearVertexBuffers();

    public VertexArrayBuilder clearVertexAttributes();

    public static enum DataType {
        BYTE(5120),
        SHORT(5122),
        INT(5124),
        FIXED(5132),
        FLOAT(5126),
        HALF_FLOAT(5131),
        DOUBLE(5130),
        UNSIGNED_BYTE(5121),
        UNSIGNED_SHORT(5123),
        UNSIGNED_INT(5125),
        INT_2_10_10_10_REV(36255),
        UNSIGNED_INT_2_10_10_10_REV(33640),
        UNSIGNED_INT_10F_11F_11F_REV(35899);

        private final int glType;

        private DataType(int glType) {
            this.glType = glType;
        }

        public int getGlType() {
            return this.glType;
        }

        public static DataType fromType(VertexFormatElement.Type type) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case VertexFormatElement.Type.FLOAT -> FLOAT;
                case VertexFormatElement.Type.UBYTE -> UNSIGNED_BYTE;
                case VertexFormatElement.Type.BYTE -> BYTE;
                case VertexFormatElement.Type.USHORT -> UNSIGNED_SHORT;
                case VertexFormatElement.Type.SHORT -> SHORT;
                case VertexFormatElement.Type.UINT -> UNSIGNED_INT;
                case VertexFormatElement.Type.INT -> INT;
            };
        }
    }
}

