/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.vertex;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.vertex.VertexArray;
import foundry.veil.api.client.render.vertex.VertexArrayBuilder;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.ARBVertexAttribBinding;
import org.lwjgl.opengl.GL20C;

@ApiStatus.Internal
public record ARBVertexAttribBindingBuilder(VertexArray vertexArray) implements VertexArrayBuilder
{
    @Override
    public VertexArrayBuilder defineVertexBuffer(int index, int buffer, int offset, int stride, int divisor) {
        ARBVertexAttribBinding.glBindVertexBuffer((int)index, (int)buffer, (long)offset, (int)stride);
        ARBVertexAttribBinding.glVertexBindingDivisor((int)index, (int)divisor);
        return this;
    }

    @Override
    public VertexArrayBuilder setVertexAttribute(int index, int bufferIndex, int size, VertexArrayBuilder.DataType type, boolean normalized, int relativeOffset) {
        VertexArrayBuilder.validateRelativeOffset(relativeOffset);
        GL20C.glEnableVertexAttribArray((int)index);
        ARBVertexAttribBinding.glVertexAttribFormat((int)index, (int)size, (int)type.getGlType(), (boolean)normalized, (int)relativeOffset);
        ARBVertexAttribBinding.glVertexAttribBinding((int)index, (int)bufferIndex);
        return this;
    }

    @Override
    public VertexArrayBuilder setVertexIAttribute(int index, int bufferIndex, int size, VertexArrayBuilder.DataType type, int relativeOffset) {
        VertexArrayBuilder.validateRelativeOffset(relativeOffset);
        GL20C.glEnableVertexAttribArray((int)index);
        ARBVertexAttribBinding.glVertexAttribIFormat((int)index, (int)size, (int)type.getGlType(), (int)relativeOffset);
        ARBVertexAttribBinding.glVertexAttribBinding((int)index, (int)bufferIndex);
        return this;
    }

    @Override
    public VertexArrayBuilder setVertexLAttribute(int index, int bufferIndex, int size, VertexArrayBuilder.DataType type, int relativeOffset) {
        if (!VeilRenderSystem.vertexAttribute64BitSupported()) {
            throw new UnsupportedOperationException("Long attributes not supported");
        }
        VertexArrayBuilder.validateRelativeOffset(relativeOffset);
        GL20C.glEnableVertexAttribArray((int)index);
        ARBVertexAttribBinding.glVertexAttribLFormat((int)index, (int)size, (int)type.getGlType(), (int)relativeOffset);
        ARBVertexAttribBinding.glVertexAttribBinding((int)index, (int)bufferIndex);
        return this;
    }

    @Override
    public VertexArrayBuilder removeVertexBuffer(int index) {
        ARBVertexAttribBinding.glBindVertexBuffer((int)index, (int)0, (long)0L, (int)0);
        return this;
    }

    @Override
    public VertexArrayBuilder removeAttribute(int index) {
        GL20C.glDisableVertexAttribArray((int)index);
        return this;
    }

    @Override
    public VertexArrayBuilder clearVertexBuffers() {
        for (int i = 0; i < VeilRenderSystem.maxVertexAttributes(); ++i) {
            ARBVertexAttribBinding.glBindVertexBuffer((int)i, (int)0, (long)0L, (int)0);
        }
        return this;
    }

    @Override
    public VertexArrayBuilder clearVertexAttributes() {
        for (int i = 0; i < VeilRenderSystem.maxVertexAttributes(); ++i) {
            GL20C.glDisableVertexAttribArray((int)i);
        }
        return this;
    }
}

