/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.texture.TextureFilter;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.NativeResource;

public class SamplerObject
implements NativeResource {
    private final int id;

    @ApiStatus.Internal
    private SamplerObject(int id) {
        this.id = id;
    }

    public static SamplerObject create() {
        RenderSystem.assertOnRenderThreadOrInit();
        return new SamplerObject(VeilRenderSystem.directStateAccessSupported() ? ARBDirectStateAccess.glCreateSamplers() : GL33C.glGenSamplers());
    }

    public static SamplerObject[] create(int count) {
        SamplerObject[] fill = new SamplerObject[count];
        SamplerObject.create(fill);
        return fill;
    }

    public static void create(SamplerObject[] fill) {
        RenderSystem.assertOnRenderThreadOrInit();
        if (fill.length == 0) {
            return;
        }
        boolean dsa = VeilRenderSystem.directStateAccessSupported();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer samplers = stack.mallocInt(fill.length);
            if (dsa) {
                ARBDirectStateAccess.glCreateSamplers((IntBuffer)samplers);
            } else {
                GL33C.glGenSamplers((IntBuffer)samplers);
            }
            for (int i = 0; i < samplers.limit(); ++i) {
                fill[i] = new SamplerObject(samplers.get(i));
            }
        }
    }

    public void bind(int unit) {
        GL33C.glBindSampler((int)unit, (int)this.id);
    }

    public static void unbind(int unit) {
        GL33C.glBindSampler((int)unit, (int)0);
    }

    public int getId() {
        return this.id;
    }

    public void setFilter(TextureFilter filter) {
        GL33C.glSamplerParameteri((int)this.id, (int)10241, (int)filter.minFilter());
        GL33C.glSamplerParameteri((int)this.id, (int)10240, (int)filter.magFilter());
        this.setAnisotropy(filter.anisotropy());
        this.setCompareFunc(filter.compareFunction());
        this.setWrap(filter.wrapX(), filter.wrapY(), filter.wrapZ());
        switch (filter.borderType()) {
            case FLOAT: {
                this.setBorderColor(filter.borderColor());
                break;
            }
            case INT: {
                this.setBorderColorI(filter.borderColor());
                break;
            }
            case UINT: {
                this.setBorderColorUI(filter.borderColor());
            }
        }
        this.setCubeMapSeamless(filter.seamless());
    }

    public void setFilter(boolean blur, boolean mipmap) {
        int magFilter;
        int minFilter;
        if (blur) {
            minFilter = mipmap ? 9987 : 9729;
            magFilter = 9729;
        } else {
            minFilter = mipmap ? 9986 : 9728;
            magFilter = 9728;
        }
        GL33C.glSamplerParameteri((int)this.id, (int)10241, (int)minFilter);
        GL33C.glSamplerParameteri((int)this.id, (int)10240, (int)magFilter);
    }

    public void setAnisotropy(float value) {
        if (VeilRenderSystem.textureAnisotropySupported()) {
            GL33C.glSamplerParameterf((int)this.id, (int)34046, (float)Math.min(value, VeilRenderSystem.maxTextureAnisotropy()));
        }
    }

    public void setCompareFunc(@Nullable TextureFilter.CompareFunction compareFunction) {
        if (compareFunction != null) {
            GL33C.glSamplerParameteri((int)this.id, (int)34892, (int)34894);
            GL33C.glSamplerParameteri((int)this.id, (int)34893, (int)compareFunction.getId());
        } else {
            GL33C.glSamplerParameteri((int)this.id, (int)34892, (int)0);
        }
    }

    public void setWrapX(TextureFilter.Wrap wrap) {
        GL33C.glSamplerParameteri((int)this.id, (int)10242, (int)wrap.getId());
    }

    public void setWrapY(TextureFilter.Wrap wrap) {
        GL33C.glSamplerParameteri((int)this.id, (int)10243, (int)wrap.getId());
    }

    public void setWrapZ(TextureFilter.Wrap wrap) {
        GL33C.glSamplerParameteri((int)this.id, (int)32882, (int)wrap.getId());
    }

    public void setWrap(TextureFilter.Wrap wrapX, TextureFilter.Wrap wrapY, TextureFilter.Wrap wrapZ) {
        GL33C.glSamplerParameteri((int)this.id, (int)10242, (int)wrapX.getId());
        GL33C.glSamplerParameteri((int)this.id, (int)10243, (int)wrapY.getId());
        GL33C.glSamplerParameteri((int)this.id, (int)32882, (int)wrapZ.getId());
    }

    public void setBorderColor(float red, float green, float blue, float alpha) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            GL33C.glSamplerParameterfv((int)this.id, (int)4100, (FloatBuffer)stack.floats(red, green, blue, alpha));
        }
    }

    public void setBorderColor(int red, int green, int blue, int alpha) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            GL33C.glSamplerParameteriv((int)this.id, (int)4100, (IntBuffer)stack.ints(red, green, blue, alpha));
        }
    }

    public void setBorderColor(int color) {
        this.setBorderColor(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF);
    }

    public void setBorderColorI(int red, int green, int blue, int alpha) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            GL33C.glGetSamplerParameterIiv((int)this.id, (int)4100, (IntBuffer)stack.ints(red, green, blue, alpha));
        }
    }

    public void setBorderColorI(int color) {
        this.setBorderColorI(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF);
    }

    public void setBorderColorUI(int red, int green, int blue, int alpha) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            GL33C.glGetSamplerParameterIuiv((int)this.id, (int)4100, (IntBuffer)stack.ints(red, green, blue, alpha));
        }
    }

    public void setBorderColorUI(int color) {
        this.setBorderColorUI(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF);
    }

    public void setCubeMapSeamless(boolean seamless) {
        if (VeilRenderSystem.textureCubeMapSeamlessSupported()) {
            GL33C.glSamplerParameteri((int)this.id, (int)34895, (int)(seamless ? 1 : 0));
        }
    }

    public void free() {
        GL33C.glDeleteSamplers((int)this.id);
    }
}

