/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.light;

import foundry.veil.api.client.editor.EditorAttributeProvider;
import foundry.veil.api.client.registry.LightTypeRegistry;
import foundry.veil.api.client.render.light.IndirectLight;
import foundry.veil.api.client.render.light.Light;
import imgui.ImGui;
import imgui.type.ImDouble;
import imgui.type.ImFloat;
import java.nio.ByteBuffer;
import net.minecraft.client.Camera;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;

public class PointLight
extends Light
implements IndirectLight<PointLight>,
EditorAttributeProvider {
    protected final Vector3d position = new Vector3d();
    protected float radius = 1.0f;

    @Override
    public void store(ByteBuffer buffer) {
        this.position.getf(buffer.position(), buffer);
        buffer.position(buffer.position() + 12);
        buffer.putFloat(this.color.x() * this.brightness);
        buffer.putFloat(this.color.y() * this.brightness);
        buffer.putFloat(this.color.z() * this.brightness);
        buffer.putFloat(this.radius);
    }

    @Override
    public Vector3dc getPosition() {
        return this.position;
    }

    @Override
    public float getRadius() {
        return this.radius;
    }

    @Override
    public PointLight setColor(float red, float green, float blue) {
        return (PointLight)super.setColor(red, green, blue);
    }

    @Override
    public PointLight setColor(Vector3fc color) {
        return (PointLight)super.setColor(color);
    }

    @Override
    public PointLight setBrightness(float brightness) {
        return (PointLight)super.setBrightness(brightness);
    }

    @Override
    public PointLight setPosition(double x, double y, double z) {
        this.position.set(x, y, z);
        this.markDirty();
        return this;
    }

    @Override
    public PointLight setRadius(float radius) {
        this.radius = radius;
        this.markDirty();
        return this;
    }

    @Override
    public PointLight setTo(Camera camera) {
        Vec3 pos = camera.getPosition();
        return this.setPosition(pos.x, pos.y, pos.z);
    }

    @Override
    public LightTypeRegistry.LightType<?> getType() {
        return LightTypeRegistry.POINT.get();
    }

    @Override
    public void renderImGuiAttributes() {
        ImDouble editX = new ImDouble(this.position.x());
        ImDouble editY = new ImDouble(this.position.y());
        ImDouble editZ = new ImDouble(this.position.z());
        ImFloat editRadius = new ImFloat(this.radius);
        float totalWidth = ImGui.calcItemWidth();
        ImGui.pushItemWidth((float)(totalWidth / 3.0f - ImGui.getStyle().getItemInnerSpacingX() * 0.58f));
        if (ImGui.dragScalar((String)"##x", (int)9, (ImDouble)editX, (float)0.02f)) {
            this.setPosition(editX.get(), this.position.y(), this.position.z());
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar((String)"##y", (int)9, (ImDouble)editY, (float)0.02f)) {
            this.setPosition(this.position.x(), editY.get(), this.position.z());
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar((String)"##z", (int)9, (ImDouble)editZ, (float)0.02f)) {
            this.setPosition(this.position.x(), this.position.y(), editZ.get());
        }
        ImGui.popItemWidth();
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text((String)"position");
        if (ImGui.dragScalar((String)"radius", (int)8, (ImFloat)editRadius, (float)0.02f, (float)0.0f)) {
            this.setRadius(editRadius.get());
        }
    }
}

