/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.ext;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import java.nio.IntBuffer;
import org.lwjgl.opengl.ARBMultiBind;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL33C;
import org.lwjgl.opengl.GLCapabilities;

public enum VeilMultiBind {
    LEGACY{

        @Override
        public void bindTextures(int first, IntBuffer textures) {
            int activeTexture = GlStateManager._getActiveTexture();
            for (int i = 0; i < textures.limit(); ++i) {
                RenderSystem.activeTexture((int)(33984 + first + i));
                if (first + i >= 12) {
                    GL11C.glBindTexture((int)3553, (int)textures.get(i));
                    continue;
                }
                RenderSystem.bindTexture((int)textures.get(i));
            }
            RenderSystem.activeTexture((int)activeTexture);
        }

        @Override
        public void bindTextures(int first, int ... textures) {
            int activeTexture = GlStateManager._getActiveTexture();
            for (int i = 0; i < textures.length; ++i) {
                RenderSystem.activeTexture((int)(33984 + first + i));
                if (first + i >= 12) {
                    GL11C.glBindTexture((int)3553, (int)textures[i]);
                    continue;
                }
                RenderSystem.bindTexture((int)textures[i]);
            }
            RenderSystem.activeTexture((int)activeTexture);
        }

        @Override
        public void bindSamplers(int first, IntBuffer samplers) {
            for (int i = 0; i < samplers.limit(); ++i) {
                GL33C.glBindSampler((int)(first + i), (int)samplers.get(i));
            }
        }

        @Override
        public void bindSamplers(int first, int ... samplers) {
            for (int i = 0; i < samplers.length; ++i) {
                GL33C.glBindSampler((int)(first + i), (int)samplers[i]);
            }
        }
    }
    ,
    SUPPORTED{

        @Override
        public void bindTextures(int first, IntBuffer textures) {
            int invalidCount = Math.min(12 - first, textures.limit());
            for (int i = first; i < invalidCount; ++i) {
                GlStateManager.TEXTURES[i].binding = textures.get(i - first);
            }
            ARBMultiBind.glBindTextures((int)first, (IntBuffer)textures);
        }

        @Override
        public void bindTextures(int first, int ... textures) {
            int invalidCount = Math.min(12 - first, textures.length);
            for (int i = first; i < invalidCount; ++i) {
                GlStateManager.TEXTURES[i].binding = textures[i - first];
            }
            ARBMultiBind.glBindTextures((int)first, (int[])textures);
        }

        @Override
        public void bindSamplers(int first, IntBuffer samplers) {
            ARBMultiBind.glBindSamplers((int)first, (IntBuffer)samplers);
        }

        @Override
        public void bindSamplers(int first, int ... samplers) {
            ARBMultiBind.glBindSamplers((int)first, (int[])samplers);
        }
    };

    private static VeilMultiBind multiBind;

    public abstract void bindTextures(int var1, IntBuffer var2);

    public abstract void bindTextures(int var1, int ... var2);

    public abstract void bindSamplers(int var1, IntBuffer var2);

    public abstract void bindSamplers(int var1, int ... var2);

    public static VeilMultiBind get() {
        if (multiBind == null) {
            GLCapabilities caps = GL.getCapabilities();
            if (caps.OpenGL44 || caps.GL_ARB_multi_bind) {
                multiBind = SUPPORTED;
                Veil.LOGGER.info("Multi-Bind supported, using core");
            } else {
                multiBind = LEGACY;
                Veil.LOGGER.info("Multi-Bind unsupported, using legacy");
            }
        }
        return multiBind;
    }
}

