/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader.block;

import com.mojang.blaze3d.platform.GlStateManager;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.block.ShaderBlock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class ShaderBlockImpl<T>
implements ShaderBlock<T> {
    protected final ShaderBlock.BufferBinding binding;
    protected int buffer;
    protected T value;
    protected boolean dirty;
    private int index;

    protected ShaderBlockImpl(ShaderBlock.BufferBinding binding) {
        this.binding = binding;
        this.buffer = 0;
        this.value = null;
        this.dirty = false;
        this.index = -1;
    }

    @Override
    public void set(@Nullable T value) {
        this.value = value;
        this.dirty = true;
    }

    public abstract void bind(int var1);

    public abstract void unbind(int var1);

    public ShaderBlock.BufferBinding getBinding() {
        return this.binding;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    @Nullable
    public T getValue() {
        return this.value;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void free() {
        VeilRenderSystem.unbind(this);
        if (this.buffer != 0) {
            GlStateManager._glDeleteBuffers((int)this.buffer);
            this.buffer = 0;
        }
    }
}

