/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.pipeline;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.VeilFramebuffers;
import foundry.veil.api.client.render.post.PostPipeline;
import foundry.veil.api.client.render.shader.program.TextureUniformAccess;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class PostPipelineContext
implements PostPipeline.Context {
    private final Map<CharSequence, Pair<Integer, Integer>> samplers = new HashMap<CharSequence, Pair<Integer, Integer>>();
    private final Map<ResourceLocation, AdvancedFbo> framebuffers = new HashMap<ResourceLocation, AdvancedFbo>();

    public void begin() {
        VeilRenderSystem.renderer().getFramebufferManager().getFramebuffers().forEach(this::setFramebuffer);
    }

    public void end() {
        this.samplers.clear();
        this.framebuffers.clear();
    }

    @Override
    public void setSampler(CharSequence name, int textureId, int samplerId) {
        this.samplers.put(name, (Pair<Integer, Integer>)Pair.of((Object)textureId, (Object)samplerId));
    }

    @Override
    public void setFramebuffer(ResourceLocation name, AdvancedFbo framebuffer) {
        this.framebuffers.put(name, framebuffer);
    }

    @Override
    public void applySamplers(TextureUniformAccess shader) {
        this.samplers.forEach((name, pair) -> shader.setSampler((CharSequence)name, (Integer)pair.getLeft(), (Integer)pair.getRight()));
    }

    @Override
    public void clearSamplers(TextureUniformAccess shader) {
        this.samplers.keySet().forEach(shader::removeSampler);
    }

    @Override
    @Nullable
    public AdvancedFbo getFramebuffer(ResourceLocation name) {
        return this.framebuffers.get(name);
    }

    @Override
    public AdvancedFbo getDrawFramebuffer() {
        return this.framebuffers.getOrDefault(VeilFramebuffers.POST, AdvancedFbo.getMainFramebuffer());
    }
}

