/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader.block;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.block.DynamicShaderBlock;
import foundry.veil.api.client.render.shader.block.ShaderBlock;
import foundry.veil.impl.client.render.shader.block.ShaderBlockImpl;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL30C;

@ApiStatus.Internal
public class WrapperShaderBlockImpl
extends ShaderBlockImpl<Object>
implements DynamicShaderBlock<Object> {
    private long size;

    public WrapperShaderBlockImpl(ShaderBlock.BufferBinding binding, int buffer) {
        super(binding);
        this.buffer = buffer;
    }

    @Override
    public void bind(int index) {
        int binding = this.binding.getGlType();
        Validate.inclusiveBetween((long)0L, (long)VeilRenderSystem.maxTargetBindings(binding), (long)index);
        GL30C.glBindBufferRange((int)binding, (int)index, (int)this.buffer, (long)0L, (long)this.size);
    }

    @Override
    public void unbind(int index) {
        int binding = this.binding.getGlType();
        Validate.inclusiveBetween((long)0L, (long)VeilRenderSystem.maxTargetBindings(binding), (long)index);
        GL30C.glBindBufferRange((int)binding, (int)index, (int)0, (long)0L, (long)this.size);
    }

    @Override
    public void set(@Nullable Object value) {
        throw new UnsupportedOperationException("Wrapper Shader Block cannot be set to a java object");
    }

    @Override
    @Nullable
    public Object getValue() {
        throw new UnsupportedOperationException("Wrapper Shader Block cannot be read as a java object");
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void setSize(long newSize) {
        this.size = newSize;
    }

    @Override
    public void free() {
        VeilRenderSystem.unbind(this);
    }
}

