/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader.block;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.block.ShaderBlock;
import foundry.veil.impl.client.render.shader.block.ShaderBlockImpl;
import java.nio.ByteBuffer;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.system.MemoryUtil;

@ApiStatus.Internal
public class SizedShaderBlockImpl<T>
extends ShaderBlockImpl<T> {
    private final Serializer<T> serializer;
    private final long size;

    public SizedShaderBlockImpl(ShaderBlock.BufferBinding binding, long size, Serializer<T> serializer) {
        super(binding);
        this.serializer = serializer;
        this.size = size;
    }

    @Override
    public void bind(int index) {
        int binding = this.binding.getGlType();
        Validate.inclusiveBetween((long)0L, (long)VeilRenderSystem.maxTargetBindings(binding), (long)index);
        if (this.buffer == 0) {
            this.dirty = true;
            this.buffer = this.serializer.createBuffer(binding, this.size);
        }
        if (this.dirty && this.serializer.write(binding, this.buffer, this.size, this.value)) {
            this.dirty = false;
        }
        GL30C.glBindBufferBase((int)binding, (int)index, (int)this.buffer);
    }

    @Override
    public void unbind(int index) {
        int binding = this.binding.getGlType();
        Validate.inclusiveBetween((long)0L, (long)VeilRenderSystem.maxTargetBindings(binding), (long)index);
        GL30C.glBindBufferBase((int)binding, (int)index, (int)0);
    }

    public static sealed interface Serializer<T>
    permits DSASerializer, LegacySerializer {
        public int createBuffer(int var1, long var2);

        public boolean write(int var1, int var2, long var3, @Nullable T var5);
    }

    public static final class LegacySerializer<T>
    implements Serializer<T> {
        private final BiConsumer<T, ByteBuffer> serializer;
        private ByteBuffer upload;

        public LegacySerializer(BiConsumer<T, ByteBuffer> serializer) {
            this.serializer = serializer;
        }

        @Override
        public int createBuffer(int binding, long size) {
            int buffer = GL15C.glGenBuffers();
            RenderSystem.glBindBuffer((int)binding, (int)buffer);
            GL15C.glBufferData((int)binding, (long)size, (int)35048);
            return buffer;
        }

        @Override
        public boolean write(int binding, int buffer, long size, @Nullable T value) {
            RenderSystem.glBindBuffer((int)binding, (int)buffer);
            this.upload = GL15C.glMapBuffer((int)binding, (int)35002, (long)size, (ByteBuffer)this.upload);
            if (this.upload != null) {
                if (value != null) {
                    this.serializer.accept(value, this.upload);
                    this.upload.rewind();
                } else {
                    MemoryUtil.memSet((ByteBuffer)this.upload, (int)0);
                }
            }
            return GL15C.glUnmapBuffer((int)binding);
        }
    }

    public static final class DSASerializer<T>
    implements Serializer<T> {
        private final BiConsumer<T, ByteBuffer> serializer;
        private ByteBuffer upload;

        public DSASerializer(BiConsumer<T, ByteBuffer> serializer) {
            this.serializer = serializer;
        }

        @Override
        public int createBuffer(int binding, long size) {
            int buffer = ARBDirectStateAccess.glCreateBuffers();
            ARBDirectStateAccess.glNamedBufferData((int)buffer, (long)size, (int)35048);
            return buffer;
        }

        @Override
        public boolean write(int binding, int buffer, long size, @Nullable T value) {
            this.upload = ARBDirectStateAccess.glMapNamedBuffer((int)buffer, (int)35001, (long)size, (ByteBuffer)this.upload);
            if (this.upload != null) {
                if (value != null) {
                    this.serializer.accept(value, this.upload);
                    this.upload.rewind();
                } else {
                    MemoryUtil.memSet((ByteBuffer)this.upload, (int)0);
                }
            }
            return ARBDirectStateAccess.glUnmapNamedBuffer((int)buffer);
        }
    }
}

