/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader.block;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.block.DynamicShaderBlock;
import foundry.veil.api.client.render.shader.block.ShaderBlock;
import foundry.veil.impl.client.render.shader.block.ShaderBlockImpl;
import java.nio.ByteBuffer;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.system.MemoryUtil;

@ApiStatus.Internal
public class DynamicShaderBlockImpl<T>
extends ShaderBlockImpl<T>
implements DynamicShaderBlock<T> {
    private final Serializer<T> serializer;
    private long size;
    private boolean resized;

    public DynamicShaderBlockImpl(ShaderBlock.BufferBinding binding, long initialSize, Serializer<T> serializer) {
        super(binding);
        this.serializer = serializer;
        this.size = initialSize;
        this.resized = false;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void setSize(long size) {
        this.size = size;
        this.resized = true;
    }

    @Override
    public void bind(int index) {
        int binding = this.binding.getGlType();
        Validate.inclusiveBetween((long)0L, (long)VeilRenderSystem.maxTargetBindings(binding), (long)index);
        if (this.buffer == 0) {
            this.resized = true;
            this.buffer = GlStateManager._glGenBuffers();
        }
        if (this.resized) {
            this.resized = false;
            this.dirty = true;
            this.serializer.resize(binding, this.buffer, this.size);
        }
        if (this.dirty && this.serializer.write(this.buffer, binding, this.size, this.value)) {
            this.dirty = false;
        }
        GL30C.glBindBufferBase((int)binding, (int)index, (int)this.buffer);
    }

    @Override
    public void unbind(int index) {
        int binding = this.binding.getGlType();
        Validate.inclusiveBetween((long)0L, (long)VeilRenderSystem.maxTargetBindings(binding), (long)index);
        GL30C.glBindBufferBase((int)binding, (int)index, (int)0);
    }

    public static sealed interface Serializer<T>
    permits DSASerializer, LegacySerializer {
        public void resize(int var1, int var2, long var3);

        public boolean write(int var1, int var2, long var3, @Nullable T var5);
    }

    public static final class LegacySerializer<T>
    implements Serializer<T> {
        private final BiConsumer<T, ByteBuffer> serializer;
        private ByteBuffer upload;

        public LegacySerializer(BiConsumer<T, ByteBuffer> serializer) {
            this.serializer = serializer;
        }

        @Override
        public void resize(int binding, int buffer, long size) {
            RenderSystem.glBindBuffer((int)binding, (int)buffer);
            GL15C.glBufferData((int)binding, (long)size, (int)35048);
        }

        @Override
        public boolean write(int binding, int buffer, long size, @Nullable T value) {
            RenderSystem.glBindBuffer((int)binding, (int)buffer);
            this.upload = GL15C.glMapBuffer((int)binding, (int)35001, (long)size, (ByteBuffer)this.upload);
            if (this.upload != null) {
                if (value != null) {
                    this.serializer.accept(value, this.upload);
                    this.upload.rewind();
                } else {
                    MemoryUtil.memSet((ByteBuffer)this.upload, (int)0);
                }
            }
            return GL15C.glUnmapBuffer((int)binding);
        }
    }

    public static final class DSASerializer<T>
    implements Serializer<T> {
        private final BiConsumer<T, ByteBuffer> serializer;
        private ByteBuffer upload;

        public DSASerializer(BiConsumer<T, ByteBuffer> serializer) {
            this.serializer = serializer;
        }

        @Override
        public void resize(int binding, int buffer, long size) {
            ARBDirectStateAccess.glNamedBufferData((int)buffer, (long)size, (int)35048);
        }

        @Override
        public boolean write(int binding, int buffer, long size, @Nullable T value) {
            this.upload = ARBDirectStateAccess.glMapNamedBuffer((int)buffer, (int)35001, (long)size, (ByteBuffer)this.upload);
            if (this.upload != null) {
                if (value != null) {
                    this.serializer.accept(value, this.upload);
                    this.upload.rewind();
                } else {
                    MemoryUtil.memSet((ByteBuffer)this.upload, (int)0);
                }
            }
            return ARBDirectStateAccess.glUnmapNamedBuffer((int)buffer);
        }
    }
}

