/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.util;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class EnumCodec<T extends Enum<?>>
implements Codec<T> {
    private final String name;
    private final T[] values;
    private final String valid;
    private final Function<T, String> toString;

    private EnumCodec(String name, T[] values, Function<T, String> toString) {
        this.name = name;
        this.values = values;
        this.valid = Arrays.stream(values).map(toString).collect(Collectors.joining(", "));
        this.toString = toString;
    }

    public <T1> DataResult<Pair<T, T1>> decode(DynamicOps<T1> ops, T1 input) {
        if (ops.compressMaps()) {
            return ops.getNumberValue(input).flatMap(index -> {
                int i = index.intValue();
                if (i < 0 || i >= this.values.length) {
                    return DataResult.error(() -> "Unknown " + this.name + " with index: " + i);
                }
                return DataResult.success((Object)Pair.of(this.values[i], (Object)input));
            });
        }
        return ops.getStringValue(input).flatMap(valueName -> {
            for (T value : this.values) {
                if (!this.toString.apply(value).equalsIgnoreCase((String)valueName)) continue;
                return DataResult.success((Object)Pair.of(value, (Object)input));
            }
            return DataResult.error(() -> "Unknown " + this.name + ": " + valueName + ". Valid options: " + this.valid);
        });
    }

    public <T1> DataResult<T1> encode(T input, DynamicOps<T1> ops, T1 prefix) {
        if (ops.compressMaps()) {
            return DataResult.success((Object)ops.createInt(((Enum)input).ordinal()));
        }
        return DataResult.success((Object)ops.createString(this.toString.apply(input)));
    }

    public static <T extends Enum<?>> Builder<T> builder(String name) {
        return new Builder(name);
    }

    public static class Builder<T extends Enum<?>> {
        private static final Function<Enum<?>, String> LOWERCASE = e -> e.name().toLowerCase(Locale.ROOT);
        private static final Function<Enum<?>, String> UPPERCASE = e -> e.name().toUpperCase(Locale.ROOT);
        private final String name;
        private T[] values;
        private Function<T, String> toString;

        public Builder(String name) {
            this.name = name;
            this.values = null;
            this.toString = LOWERCASE;
        }

        public Builder<T> values(Class<T> clazz) {
            this.values = (Enum[])clazz.getEnumConstants();
            return this;
        }

        @SafeVarargs
        public final Builder<T> values(T ... values) {
            this.values = values;
            return this;
        }

        public Builder<T> toStringFunction(Function<T, String> toString) {
            this.toString = Objects.requireNonNull(toString, "toString");
            return this;
        }

        public Builder<T> uppercase() {
            this.toString = UPPERCASE;
            return this;
        }

        public Builder<T> lowercase() {
            this.toString = LOWERCASE;
            return this;
        }

        public EnumCodec<T> build() {
            Objects.requireNonNull(this.values, "Values must be specified");
            if (this.values.length == 0) {
                throw new IllegalArgumentException("At least 1 value must be specified");
            }
            return new EnumCodec(this.name, this.values, this.toString);
        }
    }
}

