/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.compat.sodium;

import foundry.veil.api.client.render.dynamicbuffer.DynamicBufferType;
import foundry.veil.api.client.render.shader.processor.ShaderPreProcessor;
import foundry.veil.api.compat.IrisCompat;
import io.github.ocelot.glslprocessor.api.GlslInjectionPoint;
import io.github.ocelot.glslprocessor.api.GlslParser;
import io.github.ocelot.glslprocessor.api.GlslSyntaxException;
import io.github.ocelot.glslprocessor.api.grammar.GlslTypeSpecifier;
import io.github.ocelot.glslprocessor.api.node.GlslNodeList;
import io.github.ocelot.glslprocessor.api.node.GlslTree;
import io.github.ocelot.glslprocessor.api.node.function.GlslFunctionNode;
import io.github.ocelot.glslprocessor.api.visitor.GlslNodeStringWriter;
import io.github.ocelot.glslprocessor.lib.anarres.cpp.LexerException;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class SodiumShaderPreProcessor
implements ShaderPreProcessor {
    @Override
    public void modify(ShaderPreProcessor.Context ctx, GlslTree tree) throws IOException, GlslSyntaxException, LexerException {
        int activeBuffers = ctx.activeBuffers();
        if (activeBuffers == 0) {
            return;
        }
        DynamicBufferType[] buffers = DynamicBufferType.decode(activeBuffers);
        List mainBody = (List)Objects.requireNonNull(((GlslFunctionNode)tree.mainFunction().orElseThrow()).getBody());
        GlslNodeList treeBody = tree.getBody();
        GlslNodeStringWriter writer = new GlslNodeStringWriter(true);
        boolean modified = false;
        block6: for (int i = 0; i < buffers.length; ++i) {
            DynamicBufferType type = buffers[i];
            String sourceName = type.getSourceName();
            writer.clear();
            writer.visitTypeSpecifier((GlslTypeSpecifier)type.getType());
            String output = "layout(location = " + (1 + i) + ") out " + String.valueOf(writer) + " " + sourceName;
            switch (type) {
                case ALBEDO: {
                    if (ctx.isVertex()) {
                        treeBody.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression((String)"out vec4 PassVeilVertexColor"));
                        mainBody.add(GlslParser.parseExpression((String)"PassVeilVertexColor = _vert_color"));
                        modified = true;
                    }
                    if (!ctx.isFragment()) continue block6;
                    treeBody.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression((String)"in vec4 PassVeilVertexColor"));
                    treeBody.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression((String)output));
                    mainBody.add(1, GlslParser.parseExpression((String)(sourceName + " = diffuseColor * PassVeilVertexColor")));
                    modified = true;
                    continue block6;
                }
                case NORMAL: {
                    if (ctx.isVertex()) {
                        boolean iris;
                        boolean bl = iris = IrisCompat.INSTANCE != null && IrisCompat.INSTANCE.areShadersLoaded();
                        if (!iris) {
                            treeBody.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression((String)"uniform mat3 VeilNormalMatrix"));
                            treeBody.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression((String)"layout(location = 4) in vec3 VeilNormal"));
                        }
                        treeBody.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression((String)"out vec3 PassVeilNormal"));
                        mainBody.add(GlslParser.parseExpression((String)"PassVeilNormal = %s * %s".formatted(iris ? "iris_NormalMatrix" : "VeilNormalMatrix", iris ? "iris_Normal" : "VeilNormal")));
                        modified = true;
                    }
                    if (!ctx.isFragment()) continue block6;
                    treeBody.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression((String)"in vec3 PassVeilNormal"));
                    treeBody.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression((String)output));
                    mainBody.add(GlslParser.parseExpression((String)(sourceName + " = vec4(PassVeilNormal, 1.0)")));
                    modified = true;
                    continue block6;
                }
                case LIGHT_UV: {
                    if (ctx.isVertex()) {
                        treeBody.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression((String)"out vec2 PassVeilLightUV"));
                        mainBody.add(GlslParser.parseExpression((String)"PassVeilLightUV = _vert_tex_light_coord"));
                        modified = true;
                    }
                    if (!ctx.isFragment()) continue block6;
                    treeBody.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression((String)"in vec2 PassVeilLightUV"));
                    treeBody.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression((String)output));
                    mainBody.add(GlslParser.parseExpression((String)(sourceName + " = vec4(PassVeilLightUV, 0.0, 1.0)")));
                    modified = true;
                    continue block6;
                }
                case LIGHT_COLOR: {
                    if (ctx.isVertex()) {
                        treeBody.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression((String)"out vec3 PassVeilLightColor"));
                        mainBody.add(GlslParser.parseExpression((String)"PassVeilLightColor = texture(u_LightTex, _vert_tex_light_coord).rgb"));
                        modified = true;
                    }
                    if (!ctx.isFragment()) continue block6;
                    treeBody.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression((String)"in vec3 PassVeilLightColor"));
                    treeBody.add(GlslInjectionPoint.BEFORE_MAIN, GlslParser.parseExpression((String)output));
                    mainBody.add(GlslParser.parseExpression((String)(sourceName + " = vec4(PassVeilLightColor, 1.0)")));
                    modified = true;
                }
            }
        }
        if (modified && ctx.isFragment()) {
            tree.markOutputs();
        }
    }
}

