/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.light;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.Veil;
import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.DirectionalLight;
import foundry.veil.api.client.render.light.renderer.LightRenderer;
import foundry.veil.api.client.render.light.renderer.LightTypeRenderer;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.client.render.vertex.VertexArray;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@ApiStatus.Internal
public class DirectionalLightRenderer
implements LightTypeRenderer<DirectionalLight> {
    private static final Vector3f DIRECTION = new Vector3f();
    private static final ResourceLocation SHADER = Veil.veilPath("light/directional");
    private final VertexArray vertexArray = VertexArray.create();
    private int visibleLights;

    public DirectionalLightRenderer() {
        this.vertexArray.upload(DirectionalLightRenderer.createMesh(), VertexArray.DrawUsage.STATIC);
        VertexArray.unbind();
    }

    private static MeshData createMesh() {
        Tesselator tesselator = RenderSystem.renderThreadTesselator();
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION);
        LightTypeRenderer.createQuad((VertexConsumer)bufferBuilder);
        return bufferBuilder.buildOrThrow();
    }

    @Override
    public void prepareLights(LightRenderer lightRenderer, List<DirectionalLight> lights, Set<DirectionalLight> removedLights, CullFrustum frustum) {
        this.visibleLights = lights.size();
    }

    @Override
    public void renderLights(LightRenderer lightRenderer, List<DirectionalLight> lights) {
        VeilRenderSystem.setShader(SHADER);
        if (lightRenderer.applyShader()) {
            return;
        }
        ShaderProgram shader = Objects.requireNonNull(VeilRenderSystem.getShader());
        this.vertexArray.bind();
        for (DirectionalLight light : lights) {
            Vector3fc lightColor = light.getColor();
            float brightness = light.getBrightness();
            shader.setVector("LightColor", lightColor.x() * brightness, lightColor.y() * brightness, lightColor.z() * brightness);
            shader.setVector("LightDirection", (Vector3fc)DIRECTION.set(light.getDirection()).normalize());
            this.vertexArray.draw();
        }
        VertexArray.unbind();
    }

    @Override
    public int getVisibleLights() {
        return this.visibleLights;
    }

    public void free() {
        this.vertexArray.close();
    }
}

