/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.framebuffer;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.AdvancedFboTextureAttachment;
import foundry.veil.api.client.render.texture.TextureFilter;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL30C;

@ApiStatus.Internal
public class AdvancedFboMutableTextureAttachment
extends AdvancedFboTextureAttachment {
    private int textureId;
    private int layer;

    public AdvancedFboMutableTextureAttachment(int attachmentType, int textureId, int layer, String name) {
        super(attachmentType, 0, 0, 0, 0, 0, 1, TextureFilter.CLAMP, name);
        this.setTexture(textureId, layer);
    }

    @Override
    public void attach(AdvancedFbo framebuffer, int attachment) {
        int attachmentType = this.getAttachmentType();
        Validate.isTrue((attachmentType < 36096 || attachment == 0 ? 1 : 0) != 0, (String)"Only one depth buffer attachment is supported.", (Object[])new Object[0]);
        if (VeilRenderSystem.directStateAccessSupported()) {
            if (this.layer == -1) {
                ARBDirectStateAccess.glNamedFramebufferTexture((int)framebuffer.getId(), (int)(attachmentType + attachment), (int)this.textureId, (int)0);
            } else {
                ARBDirectStateAccess.glNamedFramebufferTextureLayer((int)framebuffer.getId(), (int)(attachmentType + attachment), (int)this.textureId, (int)0, (int)this.layer);
            }
        } else if (this.layer == -1) {
            GL30C.glFramebufferTexture2D((int)36160, (int)(attachmentType + attachment), (int)3553, (int)this.textureId, (int)0);
        } else {
            GL30.glFramebufferTextureLayer((int)36160, (int)(attachmentType + attachment), (int)this.textureId, (int)0, (int)this.layer);
        }
    }

    @Override
    public void create() {
    }

    @Override
    public AdvancedFboMutableTextureAttachment clone() {
        return new AdvancedFboMutableTextureAttachment(this.getAttachmentType(), this.textureId, this.layer, this.getName());
    }

    public void releaseId() {
    }

    public int getId() {
        return this.textureId;
    }

    public void setTexture(int textureId, int layer) {
        this.textureId = textureId;
        this.layer = layer;
    }
}

