/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader;

import foundry.veil.Veil;
import foundry.veil.api.client.render.shader.ShaderManager;
import foundry.veil.api.client.render.shader.processor.ShaderImporter;
import foundry.veil.api.client.render.shader.processor.ShaderPreProcessor;
import io.github.ocelot.glslprocessor.api.node.GlslTree;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.apache.commons.io.IOUtils;

public class ShaderImporterImpl
implements ShaderImporter {
    private static final String DEPRECATED_MARKER = "#veil:deprecated";
    private final ResourceProvider resourceProvider;
    private final ObjectSet<ResourceLocation> failedImports;
    private final ObjectSet<ResourceLocation> addedImports;
    private final ObjectSet<ResourceLocation> addedImportsView;
    private final Map<ResourceLocation, String> imports;

    public ShaderImporterImpl(ResourceProvider resourceProvider) {
        this.resourceProvider = resourceProvider;
        this.failedImports = new ObjectArraySet();
        this.addedImports = new ObjectArraySet();
        this.addedImportsView = ObjectSets.unmodifiable(this.addedImports);
        this.imports = new HashMap<ResourceLocation, String>();
    }

    public void reset() {
        this.addedImports.clear();
    }

    @Override
    public GlslTree loadImport(ShaderPreProcessor.Context context, ResourceLocation name, boolean force) throws IOException {
        if (this.failedImports.contains((Object)name)) {
            throw new IOException("Import previously failed to load");
        }
        if (this.addedImports.contains((Object)name) && !force) {
            return new GlslTree();
        }
        try {
            if (!this.imports.containsKey(name)) {
                try (BufferedReader reader = this.resourceProvider.openAsReader(ShaderManager.INCLUDE_LISTER.idToFile(name));){
                    this.imports.put(name, IOUtils.toString((Reader)reader));
                }
            }
            GlslTree tree = context.modifyInclude(name, this.imports.get(name));
            Iterator iterator = tree.getDirectives().iterator();
            while (iterator.hasNext()) {
                String directive = (String)iterator.next();
                if (!directive.startsWith(DEPRECATED_MARKER)) continue;
                iterator.remove();
                String message = directive.substring(DEPRECATED_MARKER.length()).trim();
                if (message.isEmpty()) {
                    Veil.LOGGER.error("Program '{}' uses deprecated import in {} shader '{}'", new Object[]{context.name(), ShaderManager.getTypeName(context.type()), name});
                    continue;
                }
                Veil.LOGGER.error("Program '{}' uses deprecated import in {} shader '{}': {}", new Object[]{context.name(), ShaderManager.getTypeName(context.type()), name, message});
            }
            return tree;
        }
        catch (Throwable t) {
            this.failedImports.add((Object)name);
            throw new IOException("Failed to add import: " + String.valueOf(name), t);
        }
    }

    public Set<ResourceLocation> addedImports() {
        return this.addedImportsView;
    }
}

