/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.program;

import foundry.veil.api.client.render.shader.program.UniformAccess;
import org.joml.Matrix2fc;
import org.joml.Matrix3fc;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3fc;
import org.joml.Vector2fc;
import org.joml.Vector2ic;
import org.joml.Vector3fc;
import org.joml.Vector3ic;
import org.joml.Vector4fc;
import org.joml.Vector4ic;

public interface MutableUniformAccess
extends UniformAccess {
    public void setUniformBlock(CharSequence var1, int var2);

    public void setStorageBlock(CharSequence var1, int var2);

    public void setFloat(CharSequence var1, float var2);

    public void setVector(CharSequence var1, float var2, float var3);

    public void setVector(CharSequence var1, float var2, float var3, float var4);

    public void setVector(CharSequence var1, float var2, float var3, float var4, float var5);

    default public void setVector(CharSequence name, Vector2fc value) {
        this.setVector(name, value.x(), value.y());
    }

    default public void setVector(CharSequence name, Vector3fc value) {
        this.setVector(name, value.x(), value.y(), value.z());
    }

    default public void setVector(CharSequence name, Vector4fc value) {
        this.setVector(name, value.x(), value.y(), value.z(), value.w());
    }

    default public void setVector(CharSequence name, float[] values) {
        switch (Math.min(4, values.length)) {
            case 1: {
                this.setFloat(name, values[0]);
                break;
            }
            case 2: {
                this.setVector(name, values[0], values[1]);
                break;
            }
            case 3: {
                this.setVector(name, values[0], values[1], values[2]);
                break;
            }
            case 4: {
                this.setVector(name, values[0], values[1], values[2], values[3]);
                break;
            }
            default: {
                throw new UnsupportedOperationException("At least 1 value must be specified");
            }
        }
    }

    public void setInt(CharSequence var1, int var2);

    public void setVectorI(CharSequence var1, int var2, int var3);

    public void setVectorI(CharSequence var1, int var2, int var3, int var4);

    public void setVectorI(CharSequence var1, int var2, int var3, int var4, int var5);

    default public void setVectorI(CharSequence name, Vector2ic value) {
        this.setVectorI(name, value.x(), value.y());
    }

    default public void setVectorI(CharSequence name, Vector3ic value) {
        this.setVectorI(name, value.x(), value.y(), value.z());
    }

    default public void setVectorI(CharSequence name, Vector4ic value) {
        this.setVectorI(name, value.x(), value.y(), value.z(), value.w());
    }

    public void setFloats(CharSequence var1, float ... var2);

    public void setVectors(CharSequence var1, Vector2fc ... var2);

    public void setVectors(CharSequence var1, Vector3fc ... var2);

    public void setVectors(CharSequence var1, Vector4fc ... var2);

    public void setInts(CharSequence var1, int ... var2);

    public void setVectors(CharSequence var1, Vector2ic ... var2);

    public void setVectors(CharSequence var1, Vector3ic ... var2);

    public void setVectors(CharSequence var1, Vector4ic ... var2);

    default public void setMatrix(CharSequence name, Matrix2fc value) {
        this.setMatrix(name, value, false);
    }

    default public void setMatrix(CharSequence name, Matrix3fc value) {
        this.setMatrix(name, value, false);
    }

    default public void setMatrix(CharSequence name, Matrix3x2fc value) {
        this.setMatrix(name, value, false);
    }

    default public void setMatrix(CharSequence name, Matrix4fc value) {
        this.setMatrix(name, value, false);
    }

    default public void setMatrix(CharSequence name, Matrix4x3fc value) {
        this.setMatrix(name, value, false);
    }

    public void setMatrix(CharSequence var1, Matrix2fc var2, boolean var3);

    public void setMatrix(CharSequence var1, Matrix3fc var2, boolean var3);

    public void setMatrix(CharSequence var1, Matrix3x2fc var2, boolean var3);

    public void setMatrix(CharSequence var1, Matrix4fc var2, boolean var3);

    public void setMatrix(CharSequence var1, Matrix4x3fc var2, boolean var3);
}

