/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.mixin.pipeline.client;

import com.mojang.blaze3d.pipeline.RenderTarget;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.ext.RenderTargetExtension;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RenderTarget.class})
public abstract class PipelineRenderTargetMixin
implements RenderTargetExtension {
    @Shadow
    public int frameBufferId;
    @Shadow
    public int viewWidth;
    @Shadow
    public int viewHeight;
    @Unique
    private AdvancedFbo veil$wrapper;

    @Override
    public void veil$setWrapper(@Nullable AdvancedFbo fbo) {
        this.veil$wrapper = fbo;
    }

    @Override
    public int veil$getFramebuffer() {
        return this.veil$wrapper != null ? this.veil$wrapper.getId() : this.frameBufferId;
    }

    @Override
    public int veil$getTexture(int buffer) {
        if (this.veil$wrapper != null && this.veil$wrapper.isColorTextureAttachment(buffer)) {
            return this.veil$wrapper.getColorTextureAttachment(buffer).getId();
        }
        return -1;
    }

    @Override
    public int veil$getWidth() {
        return this.veil$wrapper != null ? this.veil$wrapper.getWidth() : this.viewWidth;
    }

    @Override
    public int veil$getHeight() {
        return this.veil$wrapper != null ? this.veil$wrapper.getHeight() : this.viewHeight;
    }

    @Inject(method={"bindRead"}, at={@At(value="HEAD")}, cancellable=true)
    public void bindRead(CallbackInfo ci) {
        if (this.veil$wrapper != null) {
            if (this.veil$wrapper.isColorTextureAttachment(0)) {
                this.veil$wrapper.getColorTextureAttachment(0).bind();
            }
            ci.cancel();
        }
    }

    @Inject(method={"bindWrite"}, at={@At(value="HEAD")}, cancellable=true)
    public void bindWrite(boolean setViewport, CallbackInfo ci) {
        if (this.veil$wrapper != null) {
            this.veil$wrapper.bind(setViewport);
            ci.cancel();
        }
    }

    @Inject(method={"getColorTextureId"}, at={@At(value="HEAD")}, cancellable=true)
    public void getColorTextureId(CallbackInfoReturnable<Integer> cir) {
        if (this.veil$wrapper != null) {
            cir.setReturnValue((Object)this.veil$wrapper.getColorTextureAttachment(0).getId());
        }
    }

    @Inject(method={"getDepthTextureId"}, at={@At(value="HEAD")}, cancellable=true)
    public void getDepthTextureId(CallbackInfoReturnable<Integer> cir) {
        if (this.veil$wrapper != null) {
            cir.setReturnValue((Object)this.veil$wrapper.getDepthTextureAttachment().getId());
        }
    }
}

