/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.block;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.block.DynamicShaderBlock;
import foundry.veil.impl.client.render.shader.block.DynamicShaderBlockImpl;
import foundry.veil.impl.client.render.shader.block.SizedShaderBlockImpl;
import foundry.veil.impl.client.render.shader.block.WrapperShaderBlockImpl;
import io.github.ocelot.glslprocessor.api.grammar.GlslTypeQualifier;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NativeResource;

public interface ShaderBlock<T>
extends NativeResource {
    public static <T> ShaderBlock<T> withSize(BufferBinding binding, long size, BiConsumer<T, ByteBuffer> serializer) {
        return new SizedShaderBlockImpl<T>(binding, size, VeilRenderSystem.directStateAccessSupported() ? new SizedShaderBlockImpl.DSASerializer<T>(serializer) : new SizedShaderBlockImpl.LegacySerializer<T>(serializer));
    }

    public static <T> DynamicShaderBlock<T> dynamic(BufferBinding binding, BiConsumer<T, ByteBuffer> serializer) {
        return ShaderBlock.dynamic(binding, 256L, serializer);
    }

    public static <T> DynamicShaderBlock<T> dynamic(BufferBinding binding, long initialSize, BiConsumer<T, ByteBuffer> serializer) {
        return new DynamicShaderBlockImpl<T>(binding, initialSize, VeilRenderSystem.directStateAccessSupported() ? new DynamicShaderBlockImpl.DSASerializer<T>(serializer) : new DynamicShaderBlockImpl.LegacySerializer<T>(serializer));
    }

    public static DynamicShaderBlock<?> wrapper(BufferBinding binding, int buffer) {
        return new WrapperShaderBlockImpl(binding, buffer);
    }

    default public void update(@Nullable T value) {
        if (!Objects.equals(this.getValue(), value)) {
            this.set(value);
        }
    }

    public void set(@Nullable T var1);

    @Nullable
    public T getValue();

    public static enum BufferBinding {
        UNIFORM(35345),
        SHADER_STORAGE(37074);

        private final int glType;

        private BufferBinding(int glType) {
            this.glType = glType;
        }

        public int getGlType() {
            return this.glType;
        }
    }

    public static enum MemoryLayout {
        PACKED,
        SHARED,
        STD140,
        STD430;

        private final GlslTypeQualifier.LayoutId layoutId = new GlslTypeQualifier.LayoutId(this.name().toLowerCase(Locale.ROOT), null);

        public GlslTypeQualifier.LayoutId getLayoutId() {
            return this.layoutId;
        }
    }
}

