/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.registry;

import foundry.veil.api.client.render.rendertype.VeilRenderType;
import foundry.veil.ext.CompositeStateExtension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import org.jetbrains.annotations.ApiStatus;

public final class RenderTypeShardRegistry {
    private static final Map<String, List<RenderStateShard>> SHARDS = new HashMap<String, List<RenderStateShard>>();
    private static final Set<GenericShard> GENERIC_SHARDS = new HashSet<GenericShard>();
    private static final Set<RenderType.CompositeRenderType> CREATED_RENDER_TYPES = new HashSet<RenderType.CompositeRenderType>();

    private RenderTypeShardRegistry() {
    }

    public static synchronized void addShard(RenderType renderType, RenderStateShard ... shards) {
        if (shards.length == 0) {
            return;
        }
        if (!(renderType instanceof RenderType.CompositeRenderType)) {
            throw new IllegalArgumentException("RenderType must be CompositeRenderType");
        }
        RenderType.CompositeRenderType compositeRenderType = (RenderType.CompositeRenderType)renderType;
        ((CompositeStateExtension)compositeRenderType.state()).veil$addShards(Arrays.asList(shards));
    }

    public static synchronized void addShard(String name, RenderStateShard ... shards) {
        if (shards.length == 0) {
            throw new IllegalArgumentException("No shards provided");
        }
        List<RenderStateShard> newShards = Arrays.asList(shards);
        SHARDS.computeIfAbsent(name, unused -> new ArrayList()).addAll(newShards);
        for (RenderType.CompositeRenderType renderType : CREATED_RENDER_TYPES) {
            if (!name.equals(VeilRenderType.getName((RenderStateShard)renderType))) continue;
            ((CompositeStateExtension)renderType.state()).veil$addShards(newShards);
        }
    }

    public static synchronized void addGenericShard(Predicate<RenderType.CompositeRenderType> filter, RenderStateShard ... shards) {
        if (shards.length == 0) {
            throw new IllegalArgumentException("No shards provided");
        }
        GENERIC_SHARDS.add(new GenericShard(filter, shards));
        for (RenderType.CompositeRenderType renderType : CREATED_RENDER_TYPES) {
            if (!filter.test(renderType)) continue;
            ((CompositeStateExtension)renderType.state()).veil$addShards(Arrays.asList(shards));
        }
    }

    @ApiStatus.Internal
    public static void inject(RenderType.CompositeRenderType renderType) {
        List<RenderStateShard> shards = SHARDS.get(VeilRenderType.getName((RenderStateShard)renderType));
        if (shards != null) {
            shards = new ArrayList<RenderStateShard>(shards);
        }
        for (GenericShard stage : GENERIC_SHARDS) {
            if (!stage.filter.test(renderType)) continue;
            if (shards == null) {
                shards = new ArrayList<RenderStateShard>(Arrays.asList(stage.shards));
                continue;
            }
            shards.addAll(Arrays.asList(stage.shards));
        }
        if (shards != null) {
            ((CompositeStateExtension)renderType.state()).veil$addShards(shards);
        }
        CREATED_RENDER_TYPES.add(renderType);
    }

    private record GenericShard(Predicate<RenderType.CompositeRenderType> filter, RenderStateShard[] shards) {
    }
}

