/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.editor;

import foundry.veil.Veil;
import foundry.veil.api.client.editor.EditorManager;
import foundry.veil.api.client.editor.ImGuiFontMetadataSectionSerializer;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.impl.client.imgui.VeilImGuiImpl;
import imgui.ImFont;
import imgui.ImFontAtlas;
import imgui.ImFontConfig;
import imgui.ImGui;
import java.io.IOException;
import java.io.InputStream;
import java.nio.FloatBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.NativeResource;

@ApiStatus.Internal
public class ImGuiFontManager
implements PreparableReloadListener {
    private static final FileToIdConverter FONT_LISTER = new FileToIdConverter("font", ".ttf");
    private static final DecimalFormat FONT_FORMAT = new DecimalFormat("0.#");
    private static final float FONT_SIZE = 20.0f;
    private final Map<ResourceLocation, FontPackBuilder> fontBuilders = new HashMap<ResourceLocation, FontPackBuilder>();
    private final Map<ResourceLocation, FontPack> fonts = new HashMap<ResourceLocation, FontPack>();
    private ImFont defaultFont;

    public ImFont getFont(ResourceLocation name, boolean bold, boolean italic) {
        FontPack font = this.fonts.get(name);
        if (font == null) {
            return this.defaultFont;
        }
        if (italic ^ bold) {
            return italic ? font.italic : font.bold;
        }
        return italic ? font.boldItalic : font.regular;
    }

    @NotNull
    public CompletableFuture<Void> reload(@NotNull PreparableReloadListener.PreparationBarrier preparationBarrier, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller prepareProfiler, @NotNull ProfilerFiller applyProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
        if (!VeilRenderSystem.hasImGui()) {
            return preparationBarrier.wait(null);
        }
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, FontData> fontData = new HashMap<ResourceLocation, FontData>();
            for (Map.Entry entry : FONT_LISTER.listMatchingResources(resourceManager).entrySet()) {
                ResourceLocation id = FONT_LISTER.fileToId((ResourceLocation)entry.getKey());
                Resource resource = (Resource)entry.getValue();
                try {
                    InputStream stream = resource.open();
                    try {
                        short[] ranges = resource.metadata().getSection((MetadataSectionSerializer)ImGuiFontMetadataSectionSerializer.INSTANCE).map(ImGuiFontMetadataSectionSerializer.FontMetadata::ranges).orElseGet(() -> new short[]{32, 255, 0});
                        fontData.put(id, new FontData(stream.readAllBytes(), ranges));
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (IOException e) {
                    Veil.LOGGER.error("Failed to load ImGui font: {}", (Object)id, (Object)e);
                }
            }
            return fontData;
        }, backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).wait(arg_0))).thenAcceptAsync(fontData -> {
            this.fontBuilders.clear();
            block12: for (Map.Entry entry2 : fontData.entrySet()) {
                ResourceLocation id = (ResourceLocation)entry2.getKey();
                String[] parts = id.getPath().split("-", 2);
                if (parts.length < 2) continue;
                ResourceLocation name = ResourceLocation.tryBuild((String)id.getNamespace(), (String)parts[0]);
                if (name == null) {
                    Veil.LOGGER.error("Invalid font name: {}:{}", (Object)id.getNamespace(), (Object)parts[0]);
                    continue;
                }
                String type = parts[1];
                FontPackBuilder builder = this.fontBuilders.computeIfAbsent(name, FontPackBuilder::new);
                switch (type) {
                    case "regular": {
                        builder.main = (FontData)entry2.getValue();
                        continue block12;
                    }
                    case "italic": {
                        builder.italic = (FontData)entry2.getValue();
                        continue block12;
                    }
                    case "bold": {
                        builder.bold = (FontData)entry2.getValue();
                        continue block12;
                    }
                    case "bold_italic": {
                        builder.boldItalic = (FontData)entry2.getValue();
                        continue block12;
                    }
                }
                Veil.LOGGER.warn("Unknown font type {} for font: {}", (Object)type, (Object)name);
            }
            this.fontBuilders.entrySet().removeIf(entry -> {
                if (entry.getValue() == null) {
                    Veil.LOGGER.warn("Skipping invalid font: {}", entry.getKey());
                    return true;
                }
                return false;
            });
            Veil.LOGGER.info("Loaded {} ImGui fonts", (Object)this.fontBuilders.size());
            this.rebuildFonts();
        }, gameExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildFonts() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            Veil.beginImGui();
            ImFontAtlas atlas = ImGui.getIO().getFonts();
            atlas.clear();
            this.defaultFont = atlas.addFontDefault();
            this.fonts.clear();
            FloatBuffer xscale = stack.mallocFloat(1);
            FloatBuffer yscale = stack.mallocFloat(1);
            GLFW.glfwGetMonitorContentScale((long)GLFW.glfwGetPrimaryMonitor(), (FloatBuffer)xscale, (FloatBuffer)yscale);
            float scale = Math.max(xscale.get(0), yscale.get(0));
            if (Minecraft.ON_OSX) {
                scale /= 2.0f;
            }
            scale = Math.max(1.0f, scale);
            for (Map.Entry<ResourceLocation, FontPackBuilder> entry : this.fontBuilders.entrySet()) {
                Veil.LOGGER.info("Built {}", (Object)entry.getKey());
                this.fonts.put(entry.getKey(), entry.getValue().build(20.0f * scale));
            }
            ImGui.getIO().setFontDefault(this.getFont(EditorManager.DEFAULT_FONT, false, false));
            VeilImGuiImpl.get().updateFonts();
        }
        finally {
            Veil.endImGui();
        }
    }

    private record FontPack(ImFont regular, ImFont italic, ImFont bold, ImFont boldItalic, ImFontConfig[] configs) implements NativeResource
    {
        public void free() {
            this.regular.destroy();
            if (this.italic != this.regular) {
                this.italic.destroy();
            }
            if (this.bold != this.regular) {
                this.bold.destroy();
            }
            if (this.boldItalic != this.regular) {
                this.boldItalic.destroy();
            }
            for (ImFontConfig config : this.configs) {
                config.destroy();
            }
        }
    }

    private static class FontPackBuilder {
        private final ResourceLocation name;
        private final List<ImFontConfig> configs;
        private FontData main;
        private FontData italic;
        private FontData bold;
        private FontData boldItalic;

        private FontPackBuilder(ResourceLocation name) {
            this.name = name;
            this.configs = new ArrayList<ImFontConfig>(4);
        }

        private ImFont loadOrDefault(@Nullable FontData data, String type, float sizePixels, ImFont defaultFont) {
            if (data == null) {
                return defaultFont;
            }
            ImFontAtlas atlas = ImGui.getIO().getFonts();
            ImFontConfig fontConfig = new ImFontConfig();
            this.configs.add(fontConfig);
            fontConfig.setName(this.name.getPath() + " " + type + " " + FONT_FORMAT.format(sizePixels) + " px");
            fontConfig.setGlyphRanges(data.ranges);
            return atlas.addFontFromMemoryTTF(data.bytes, sizePixels, fontConfig);
        }

        public FontPack build(float sizePixels) {
            ImFont main = Objects.requireNonNull(this.loadOrDefault(this.main, "regular", sizePixels, null));
            ImFont italic = this.loadOrDefault(this.italic, "italic", sizePixels, main);
            ImFont bold = this.loadOrDefault(this.bold, "bold", sizePixels, main);
            ImFont boldItalic = this.loadOrDefault(this.boldItalic, "bold_italic", sizePixels, main);
            return new FontPack(main, italic, bold, boldItalic, (ImFontConfig[])this.configs.toArray(ImFontConfig[]::new));
        }
    }

    private record FontData(byte[] bytes, short[] ranges) {
    }
}

