/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.wrapper;

import com.mojang.blaze3d.pipeline.RenderTarget;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.ext.RenderTargetExtension;
import foundry.veil.impl.client.render.wrapper.VanillaAdvancedFboWrapper;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.ARBClearTexture;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.system.MemoryStack;

@ApiStatus.Internal
public class DSAVanillaAdvancedFboWrapper
extends VanillaAdvancedFboWrapper {
    public DSAVanillaAdvancedFboWrapper(Supplier<RenderTarget> renderTargetSupplier) {
        super(renderTargetSupplier);
    }

    @Override
    public void clear(float red, float green, float blue, float alpha, int clearMask, int ... clearBuffers) {
        if (clearMask == 0) {
            return;
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            boolean clearTex = VeilRenderSystem.clearTextureSupported();
            RenderTarget renderTarget = this.toRenderTarget();
            if ((clearMask & 0x4000) != 0) {
                if (clearTex) {
                    ARBClearTexture.glClearTexImage((int)renderTarget.getColorTextureId(), (int)0, (int)6408, (int)5126, (FloatBuffer)stack.floats(red, green, blue, alpha));
                } else {
                    ARBDirectStateAccess.glClearNamedFramebufferfv((int)renderTarget.getColorTextureId(), (int)6144, (int)0, (FloatBuffer)stack.floats(red, green, blue, alpha));
                }
            }
            if (renderTarget.useDepth) {
                boolean stencil;
                boolean hasStencil = this.hasStencilAttachment();
                boolean depth = (clearMask & 0x100) != 0;
                boolean bl = stencil = hasStencil && (clearMask & 0x400) != 0;
                if (!depth && !stencil) {
                    return;
                }
                if (hasStencil) {
                    if (depth && stencil) {
                        if (clearTex) {
                            ARBClearTexture.glClearTexImage((int)renderTarget.getDepthTextureId(), (int)0, (int)34041, (int)36269, (ByteBuffer)null);
                        } else {
                            ARBDirectStateAccess.glClearNamedFramebufferfi((int)this.getId(), (int)34041, (int)0, (float)1.0f, (int)0);
                        }
                    } else {
                        if (depth) {
                            ARBDirectStateAccess.glClearNamedFramebufferfv((int)this.getId(), (int)6145, (int)0, (FloatBuffer)stack.floats(1.0f));
                        }
                        if (stencil) {
                            ARBDirectStateAccess.glClearNamedFramebufferiv((int)this.getId(), (int)6146, (int)0, (IntBuffer)stack.ints(0));
                        }
                    }
                } else if (clearTex) {
                    ARBClearTexture.glClearTexImage((int)renderTarget.getDepthTextureId(), (int)0, (int)6402, (int)5126, (FloatBuffer)stack.floats(1.0f));
                } else {
                    ARBDirectStateAccess.glClearNamedFramebufferfv((int)this.getId(), (int)6145, (int)0, (FloatBuffer)stack.floats(1.0f));
                }
            }
        }
        if (Minecraft.ON_OSX) {
            GL30C.glGetError();
        }
    }

    @Override
    public void resolveToFbo(int id, int width, int height, int mask, int filtering) {
        ARBDirectStateAccess.glBlitNamedFramebuffer((int)this.getId(), (int)id, (int)0, (int)0, (int)this.getWidth(), (int)this.getHeight(), (int)0, (int)0, (int)width, (int)height, (int)mask, (int)filtering);
    }

    @Override
    public void resolveToAdvancedFbo(AdvancedFbo target, int mask, int filtering) {
        ARBDirectStateAccess.glBlitNamedFramebuffer((int)this.getId(), (int)target.getId(), (int)0, (int)0, (int)this.getWidth(), (int)this.getHeight(), (int)0, (int)0, (int)target.getWidth(), (int)target.getHeight(), (int)mask, (int)filtering);
    }

    @Override
    public void resolveToRenderTarget(RenderTarget target, int mask, int filtering) {
        RenderTargetExtension extension = (RenderTargetExtension)target;
        ARBDirectStateAccess.glBlitNamedFramebuffer((int)this.getId(), (int)extension.veil$getFramebuffer(), (int)0, (int)0, (int)this.getWidth(), (int)this.getHeight(), (int)0, (int)0, (int)extension.veil$getWidth(), (int)extension.veil$getHeight(), (int)mask, (int)filtering);
    }
}

