/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.imgui;

import foundry.veil.Veil;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.impl.client.imgui.AdvancedFboImGuiAreaImpl;
import foundry.veil.impl.client.imgui.InactiveVeilImGuiImpl;
import foundry.veil.impl.client.imgui.VeilImGui;
import foundry.veil.impl.client.imgui.VeilImGuiImplGlfw;
import foundry.veil.impl.client.imgui.VeilImGuiStylesheet;
import imgui.ImGui;
import imgui.ImGuiIO;
import imgui.callback.ImStrConsumer;
import imgui.callback.ImStrSupplier;
import imgui.extension.implot.ImPlot;
import imgui.extension.implot.ImPlotContext;
import imgui.gl3.ImGuiImplGl3;
import imgui.glfw.ImGuiImplGlfw;
import imgui.internal.ImGuiContext;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.ObjIntConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.NativeResource;

@ApiStatus.Internal
public class VeilImGuiImpl
implements VeilImGui,
NativeResource {
    private static VeilImGui instance = new InactiveVeilImGuiImpl();
    private final ImGuiImplGlfw implGlfw = new VeilImGuiImplGlfw(this);
    private final ImGuiImplGl3 implGl3 = new ImGuiImplGl3();
    private final ImguiState state = new ImguiState();
    private final ImGuiContext imGuiContext;
    private final ImPlotContext imPlotContext;
    private final AtomicBoolean active;

    private VeilImGuiImpl(long window) {
        ImGuiContext oldImGuiContext = new ImGuiContext(ImGui.getCurrentContext().ptr);
        ImPlotContext oldImPlotContext = new ImPlotContext(ImPlot.getCurrentContext().ptr);
        this.imGuiContext = new ImGuiContext(ImGui.createContext().ptr);
        this.imPlotContext = new ImPlotContext(ImPlot.createContext().ptr);
        this.active = new AtomicBoolean();
        this.implGlfw.init(window, true);
        this.implGl3.init("#version 410 core");
        VeilImGuiStylesheet.initStyles();
        ImGuiIO io = ImGui.getIO();
        io.setGetClipboardTextFn(new ImStrSupplier(this){

            public String get() {
                return Minecraft.getInstance().keyboardHandler.getClipboard();
            }
        });
        io.setSetClipboardTextFn(new ImStrConsumer(this){

            public void accept(String str) {
                Minecraft.getInstance().keyboardHandler.setClipboard(str);
            }
        });
        ImGui.setCurrentContext((ImGuiContext)oldImGuiContext);
        ImPlot.setCurrentContext((ImPlotContext)oldImPlotContext);
    }

    @Override
    public void start() {
        this.state.start(this.imGuiContext, this.imPlotContext);
    }

    @Override
    public void stop() {
        this.state.end();
    }

    @Override
    public void beginFrame() {
        this.start();
        if (this.active.get()) {
            Veil.LOGGER.error("ImGui failed to render previous frame, disposing");
            ImGui.endFrame();
        }
        this.active.set(true);
        this.implGlfw.newFrame();
        ImGui.newFrame();
        AdvancedFboImGuiAreaImpl.begin();
        VeilRenderSystem.renderer().getEditorManager().render();
        this.stop();
    }

    @Override
    public void endFrame() {
        AdvancedFboImGuiAreaImpl.end();
        if (!this.active.get()) {
            Veil.LOGGER.error("ImGui state de-synced");
            this.stop();
            return;
        }
        this.start();
        this.active.set(false);
        VeilRenderSystem.renderer().getEditorManager().renderLast();
        ImGui.render();
        this.implGl3.renderDrawData(ImGui.getDrawData());
        if (ImGui.getIO().hasConfigFlags(1024)) {
            long backupWindowPtr = GLFW.glfwGetCurrentContext();
            ImGui.updatePlatformWindows();
            ImGui.renderPlatformWindowsDefault();
            GLFW.glfwMakeContextCurrent((long)backupWindowPtr);
        }
        this.state.forceEnd();
    }

    @Override
    public void onGrabMouse() {
        ImGui.setWindowFocus(null);
    }

    @Override
    public void toggle() {
        VeilRenderSystem.renderer().getEditorManager().toggle();
    }

    @Override
    public void updateFonts() {
        this.implGl3.updateFontsTexture();
    }

    @Override
    public void addImguiShaders(ObjIntConsumer<ResourceLocation> registry) {
        try {
            Field field = ImGuiImplGl3.class.getDeclaredField("gShaderHandle");
            field.setAccessible(true);
            int handle = field.getInt(this.implGl3);
            registry.accept(ResourceLocation.fromNamespaceAndPath((String)"imgui", (String)"blit"), handle);
        }
        catch (Exception e) {
            Veil.LOGGER.warn("Failed to add ImGui shader", (Throwable)e);
        }
    }

    @Override
    public boolean mouseButtonCallback(long window, int button, int action, int mods) {
        return ImGui.getIO().getWantCaptureMouse();
    }

    @Override
    public boolean scrollCallback(long window, double xOffset, double yOffset) {
        return ImGui.getIO().getWantCaptureMouse();
    }

    @Override
    public boolean keyCallback(long window, int key, int scancode, int action, int mods) {
        return ImGui.getIO().getWantCaptureKeyboard();
    }

    @Override
    public boolean charCallback(long window, int codepoint) {
        return ImGui.getIO().getWantCaptureKeyboard();
    }

    @Override
    public boolean shouldHideMouse() {
        return ImGui.getIO().getWantCaptureMouse();
    }

    public void free() {
        this.start();
        this.implGlfw.dispose();
        this.implGl3.dispose();
        ImGui.destroyContext((ImGuiContext)this.imGuiContext);
        ImPlot.destroyContext((ImPlotContext)this.imPlotContext);
        this.stop();
    }

    public static void init(long window) {
        try {
            instance = Veil.IMGUI ? new VeilImGuiImpl(window) : new InactiveVeilImGuiImpl();
        }
        catch (Throwable t) {
            Veil.LOGGER.error("Failed to load ImGui", t);
            instance = new InactiveVeilImGuiImpl();
        }
    }

    public static void setImGuiPath() {
        if (System.getProperty("os.arch").equals("arm") || System.getProperty("os.arch").startsWith("aarch64")) {
            System.setProperty("imgui.library.name", "libimgui-javaarm64.dylib");
        }
    }

    public static VeilImGui get() {
        return instance;
    }

    private static class ImguiState {
        private final ImGuiContext oldImGuiContext = new ImGuiContext(0L);
        private final ImPlotContext oldImPlotContext = new ImPlotContext(0L);
        private int beginLayer;

        public void start(ImGuiContext imGuiContext, ImPlotContext imPlotContext) {
            ++this.beginLayer;
            if (ImGui.getCurrentContext().ptr == imGuiContext.ptr) {
                return;
            }
            this.oldImGuiContext.ptr = ImGui.getCurrentContext().ptr;
            this.oldImPlotContext.ptr = ImPlot.getCurrentContext().ptr;
            ImGui.setCurrentContext((ImGuiContext)imGuiContext);
            ImPlot.setCurrentContext((ImPlotContext)imPlotContext);
        }

        public void end() {
            if (--this.beginLayer == 0) {
                ImGui.setCurrentContext((ImGuiContext)this.oldImGuiContext);
                ImPlot.setCurrentContext((ImPlotContext)this.oldImPlotContext);
                this.oldImGuiContext.ptr = 0L;
                this.oldImPlotContext.ptr = 0L;
            }
        }

        public void forceEnd() {
            if (this.beginLayer > 1) {
                Veil.LOGGER.error("Mismatched begin/end during frame");
                this.beginLayer = 1;
            }
            this.end();
        }
    }
}

