/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.framebuffer;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.ext.VeilDebug;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.AdvancedFboAttachment;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.ARBDirectStateAccess;
import org.lwjgl.opengl.GL30;

public class AdvancedFboRenderAttachment
implements AdvancedFboAttachment {
    private int id;
    private final int attachmentType;
    private final int attachmentFormat;
    private final int width;
    private final int height;
    private final int samples;

    public AdvancedFboRenderAttachment(int attachmentType, int attachmentFormat, int width, int height, int samples) {
        this.attachmentType = attachmentType;
        this.attachmentFormat = attachmentFormat;
        this.width = width;
        this.height = height;
        Validate.inclusiveBetween((long)1L, (long)VeilRenderSystem.maxSamples(), (long)samples);
        this.samples = samples;
    }

    @Override
    public void create() {
        if (VeilRenderSystem.directStateAccessSupported()) {
            if (this.samples == 1) {
                ARBDirectStateAccess.glNamedRenderbufferStorage((int)this.id, (int)this.attachmentFormat, (int)this.width, (int)this.height);
            } else {
                ARBDirectStateAccess.glNamedRenderbufferStorageMultisample((int)this.id, (int)this.samples, (int)this.attachmentFormat, (int)this.width, (int)this.height);
            }
        } else {
            this.bindAttachment();
            if (this.samples == 1) {
                GL30.glRenderbufferStorage((int)36161, (int)this.attachmentFormat, (int)this.width, (int)this.height);
            } else {
                GL30.glRenderbufferStorageMultisample((int)36161, (int)this.samples, (int)this.attachmentFormat, (int)this.width, (int)this.height);
            }
            this.unbindAttachment();
        }
    }

    @Override
    public void attach(AdvancedFbo framebuffer, int attachment) {
        Validate.isTrue((this.attachmentType != 36096 || attachment == 0 ? 1 : 0) != 0, (String)"Only one depth buffer attachment is supported.", (Object[])new Object[0]);
        int id = this.getId();
        if (VeilRenderSystem.directStateAccessSupported()) {
            ARBDirectStateAccess.glNamedFramebufferRenderbuffer((int)framebuffer.getId(), (int)this.attachmentType, (int)36161, (int)id);
        } else {
            GL30.glFramebufferRenderbuffer((int)36160, (int)this.attachmentType, (int)36161, (int)id);
        }
        String debugLabel = framebuffer.getDebugLabel();
        if (debugLabel != null) {
            if (this.attachmentType == 36096) {
                VeilDebug.get().objectLabel(36161, id, "Advanced Fbo " + debugLabel + " Depth Render Buffer");
            } else {
                VeilDebug.get().objectLabel(36161, id, "Advanced Fbo " + debugLabel + " Render Buffer " + attachment);
            }
        }
    }

    @Override
    public void bindAttachment() {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> GL30.glBindRenderbuffer((int)36161, (int)this.getId()));
        } else {
            GL30.glBindRenderbuffer((int)36161, (int)this.getId());
        }
    }

    @Override
    public void unbindAttachment() {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> GL30.glBindRenderbuffer((int)36161, (int)0));
        } else {
            GL30.glBindRenderbuffer((int)36161, (int)0);
        }
    }

    public int getId() {
        RenderSystem.assertOnRenderThreadOrInit();
        if (this.id == 0) {
            this.id = VeilRenderSystem.directStateAccessSupported() ? ARBDirectStateAccess.glCreateRenderbuffers() : GL30.glGenRenderbuffers();
        }
        return this.id;
    }

    @Override
    public int getAttachmentType() {
        return this.attachmentType;
    }

    @Override
    public int getFormat() {
        return this.attachmentFormat;
    }

    @Override
    public int getLevels() {
        return this.samples;
    }

    @Override
    public boolean canSample() {
        return false;
    }

    @Override
    @Nullable
    public String getName() {
        return null;
    }

    @Override
    @NotNull
    public AdvancedFboAttachment clone() {
        return new AdvancedFboRenderAttachment(this.attachmentType, this.attachmentFormat, this.width, this.height, this.samples);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdvancedFboRenderAttachment that = (AdvancedFboRenderAttachment)o;
        return this.id == that.id && this.attachmentType == that.attachmentType && this.attachmentFormat == that.attachmentFormat && this.width == that.width && this.height == that.height && this.samples == that.samples;
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + this.attachmentType;
        result = 31 * result + this.attachmentFormat;
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        result = 31 * result + this.samples;
        return result;
    }

    public void free() {
        if (this.id != 0) {
            GL30.glDeleteRenderbuffers((int)this.id);
        }
        this.id = 0;
    }
}

