/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.neoforge;

import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.Veil;
import foundry.veil.VeilClient;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.deferred.VeilDeferredRenderer;
import foundry.veil.impl.client.render.VeilUITooltipRenderer;
import foundry.veil.impl.client.render.shader.VeilVanillaShaders;
import foundry.veil.neoforge.NeoForgeRenderTypeStageHandler;
import foundry.veil.neoforge.event.NeoForgeVeilRegisterFixedBuffersEvent;
import foundry.veil.neoforge.event.NeoForgeVeilRendererEvent;
import java.nio.file.Path;
import java.util.function.Consumer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiOverlaysEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.client.gui.overlay.VanillaGuiOverlay;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class VeilNeoForgeClient {
    public static void init(IEventBus modEventBus) {
        VeilClient.init();
        modEventBus.addListener(VeilNeoForgeClient::registerKeys);
        modEventBus.addListener(VeilNeoForgeClient::registerGuiOverlays);
        modEventBus.addListener(VeilNeoForgeClient::registerListeners);
        modEventBus.addListener(VeilNeoForgeClient::registerShaders);
        modEventBus.addListener(VeilNeoForgeClient::addPackFinders);
    }

    private static void registerListeners(RegisterClientReloadListenersEvent event) {
        VeilClient.initRenderer();
        NeoForge.EVENT_BUS.post((Event)new NeoForgeVeilRendererEvent(VeilRenderSystem.renderer()));
        NeoForge.EVENT_BUS.post((Event)new NeoForgeVeilRegisterFixedBuffersEvent(NeoForgeRenderTypeStageHandler::register));
    }

    private static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(VeilClient.EDITOR_KEY);
    }

    private static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.HOTBAR.id(), Veil.veilPath("uitooltip"), VeilUITooltipRenderer::renderOverlay);
    }

    private static void registerShaders(RegisterShadersEvent event) {
        try {
            VeilVanillaShaders.registerShaders((ResourceLocation id, VertexFormat vertexFormat, Consumer<ShaderInstance> loadCallback) -> event.registerShader(new ShaderInstance(event.getResourceProvider(), id, vertexFormat), loadCallback));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            if (Veil.DEBUG && !FMLLoader.isProduction()) {
                VeilNeoForgeClient.registerBuiltinPack(event, Veil.veilPath("test_shaders"));
            }
            VeilNeoForgeClient.registerBuiltinPack(event, VeilDeferredRenderer.PACK_ID);
        }
    }

    private static void registerBuiltinPack(AddPackFindersEvent event, ResourceLocation id) {
        final Path resourcePath = ModList.get().getModFileById("veil").getFile().findResource(new String[]{"resourcepacks/" + id.getPath()});
        Pack pack = Pack.readMetaAndCreate((String)id.toString(), (Component)Component.literal((String)(id.getNamespace() + "/" + id.getPath())), (boolean)false, (Pack.ResourcesSupplier)new Pack.ResourcesSupplier(){

            public PackResources openPrimary(String s) {
                return new PathPackResources(s, resourcePath, false);
            }

            public PackResources openFull(String s, Pack.Info info) {
                return new PathPackResources(s, resourcePath, false);
            }
        }, (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.BUILT_IN);
        event.addRepositorySource(packConsumer -> packConsumer.accept(pack));
    }
}

