/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.mixin.client.anim;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import foundry.veil.ext.ModelPartExtension;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.model.geom.ModelPart;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelPart.class})
public class ModelPartMixin
implements ModelPartExtension {
    @Unique
    public float offsetX = 0.0f;
    @Unique
    public float offsetY = 0.0f;
    @Unique
    public float offsetZ = 0.0f;
    @Unique
    private Supplier<ModelPart> parent = () -> null;
    @Shadow
    @Final
    private Map<String, ModelPart> children;

    @Override
    public float veil$getOffsetX() {
        return this.offsetX;
    }

    @Override
    public float veil$getOffsetY() {
        return this.offsetY;
    }

    @Override
    public float veil$getOffsetZ() {
        return this.offsetZ;
    }

    @Override
    public void veil$setOffset(float x, float y, float z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
    }

    @Override
    public boolean veil$isChild(ModelPart part) {
        return this.children.containsValue(part);
    }

    @Inject(method={"translateAndRotate(Lcom/mojang/blaze3d/vertex/PoseStack;)V"}, at={@At(value="TAIL")})
    public void veil$rotato(PoseStack matrix, CallbackInfo ci) {
        if (this.offsetX != 0.0f || this.offsetY != 0.0f || this.offsetZ != 0.0f) {
            matrix.translate(this.offsetX / 16.0f, this.offsetY / 16.0f, this.offsetZ / 16.0f);
        }
    }

    @Inject(method={"translateAndRotate(Lcom/mojang/blaze3d/vertex/PoseStack;)V"}, at={@At(value="HEAD")})
    public void veil$protato(PoseStack matrix, CallbackInfo ci) {
        if (this.parent.get() != null) {
            this.act(this.parent.get(), matrix);
        }
    }

    @Inject(method={"copyFrom"}, at={@At(value="TAIL")})
    public void veil$copyTrans(ModelPart part, CallbackInfo ci) {
        this.offsetX = ((ModelPartExtension)part).veil$getOffsetX();
        this.offsetY = ((ModelPartExtension)part).veil$getOffsetY();
        this.offsetZ = ((ModelPartExtension)part).veil$getOffsetZ();
    }

    @Override
    public Supplier<ModelPart> veil$getParent() {
        return this.parent;
    }

    @Override
    public void veil$setParent(Supplier<ModelPart> parent) {
        this.parent = parent;
    }

    @Unique
    private void act(ModelPart part, PoseStack matrix) {
        matrix.translate(part.x / 16.0f, part.y / 16.0f, part.z / 16.0f);
        if (part.zRot != 0.0f) {
            matrix.mulPose(Axis.ZP.rotation(part.zRot));
        }
        if (part.yRot != 0.0f) {
            matrix.mulPose(Axis.YP.rotation(part.yRot));
        }
        if (part.xRot != 0.0f) {
            matrix.mulPose(Axis.XP.rotation(part.xRot));
        }
        if (part.xScale != 1.0f || part.yScale != 1.0f || part.zScale != 1.0f) {
            matrix.scale(part.xScale, part.yScale, part.zScale);
        }
        if (((ModelPartExtension)part).veil$getOffsetX() != 0.0f || ((ModelPartExtension)part).veil$getOffsetY() != 0.0f || ((ModelPartExtension)part).veil$getOffsetZ() != 0.0f) {
            matrix.translate(((ModelPartExtension)part).veil$getOffsetX() / 16.0f, ((ModelPartExtension)part).veil$getOffsetY() / 16.0f, ((ModelPartExtension)part).veil$getOffsetZ() / 16.0f);
        }
    }
}

